/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.datacache.nonkeyed.SegmentReader;

@Internal
class FileSegmentReader<T>
implements SegmentReader<T> {
    private final TypeSerializer<T> serializer;
    private final FSDataInputStream inputStream;
    private final DataInputView inputView;
    private final int totalCount;
    private int count;

    FileSegmentReader(TypeSerializer<T> serializer, Segment segment, int startOffset) throws IOException {
        this.serializer = serializer;
        Path path = segment.getPath();
        this.inputStream = path.getFileSystem().open(path);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)this.inputStream);
        this.inputView = new DataInputViewStreamWrapper((InputStream)bufferedInputStream);
        this.totalCount = segment.getCount();
        this.count = 0;
        for (int i = 0; i < startOffset; ++i) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.count < this.totalCount;
    }

    @Override
    public T next() throws IOException {
        Object value = this.serializer.deserialize(this.inputView);
        ++this.count;
        return (T)value;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

