/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.allround;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.OperatorWrapper;
import org.apache.flink.iteration.operator.allround.MultipleInputAllRoundWrapperOperator;
import org.apache.flink.iteration.operator.allround.OneInputAllRoundWrapperOperator;
import org.apache.flink.iteration.operator.allround.TwoInputAllRoundWrapperOperator;
import org.apache.flink.iteration.proxy.ProxyKeySelector;
import org.apache.flink.iteration.proxy.ProxyStreamPartitioner;
import org.apache.flink.iteration.typeinfo.IterationRecordTypeInfo;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;

public class AllRoundOperatorWrapper<T>
implements OperatorWrapper<T, IterationRecord<T>> {
    @Override
    public StreamOperator<IterationRecord<T>> wrap(StreamOperatorParameters<IterationRecord<T>> operatorParameters, StreamOperatorFactory<T> operatorFactory) {
        Class operatorClass = operatorFactory.getStreamOperatorClass(this.getClass().getClassLoader());
        if (OneInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return new OneInputAllRoundWrapperOperator(operatorParameters, operatorFactory);
        }
        if (TwoInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return new TwoInputAllRoundWrapperOperator(operatorParameters, operatorFactory);
        }
        if (MultipleInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return new MultipleInputAllRoundWrapperOperator<T>(operatorParameters, operatorFactory);
        }
        throw new UnsupportedOperationException("Unsupported operator class for all-round wrapper: " + operatorClass);
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader, StreamOperatorFactory<T> operatorFactory) {
        Class operatorClass = operatorFactory.getStreamOperatorClass(this.getClass().getClassLoader());
        if (OneInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return OneInputAllRoundWrapperOperator.class;
        }
        if (TwoInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return TwoInputAllRoundWrapperOperator.class;
        }
        if (MultipleInputStreamOperator.class.isAssignableFrom(operatorClass)) {
            return MultipleInputAllRoundWrapperOperator.class;
        }
        throw new UnsupportedOperationException("Unsupported operator class for all-round wrapper: " + operatorClass);
    }

    @Override
    public <KEY> KeySelector<IterationRecord<T>, KEY> wrapKeySelector(KeySelector<T, KEY> keySelector) {
        return new ProxyKeySelector<T, KEY>(keySelector);
    }

    @Override
    public StreamPartitioner<IterationRecord<T>> wrapStreamPartitioner(StreamPartitioner<T> streamPartitioner) {
        if (streamPartitioner instanceof BroadcastPartitioner) {
            return new BroadcastPartitioner();
        }
        return new ProxyStreamPartitioner<T>(streamPartitioner);
    }

    @Override
    public OutputTag<IterationRecord<T>> wrapOutputTag(OutputTag<T> outputTag) {
        return new OutputTag(outputTag.getId(), new IterationRecordTypeInfo(outputTag.getTypeInfo()));
    }

    @Override
    public TypeInformation<IterationRecord<T>> getWrappedTypeInfo(TypeInformation<T> typeInfo) {
        return new IterationRecordTypeInfo<T>(typeInfo);
    }
}

