/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.perround;

import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.operator.perround.AbstractPerRoundWrapperOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.ThrowingConsumer;

public class TwoInputPerRoundWrapperOperator<IN1, IN2, OUT>
extends AbstractPerRoundWrapperOperator<OUT, TwoInputStreamOperator<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IterationRecord<IN1>, IterationRecord<IN2>, IterationRecord<OUT>> {
    private final StreamRecord<IN1> reusedInput1 = new StreamRecord(null, 0L);
    private final StreamRecord<IN2> reusedInput2 = new StreamRecord(null, 0L);

    public TwoInputPerRoundWrapperOperator(StreamOperatorParameters<IterationRecord<OUT>> parameters, StreamOperatorFactory<OUT> operatorFactory) {
        super(parameters, operatorFactory);
    }

    @Override
    protected void endInputAndEmitMaxWatermark(TwoInputStreamOperator<IN1, IN2, OUT> operator, int epoch, int epochWatermark) throws Exception {
        OperatorUtils.processOperatorOrUdfIfSatisfy(operator, BoundedMultiInput.class, boundedMultiInput -> {
            boundedMultiInput.endInput(1);
            boundedMultiInput.endInput(2);
        });
        operator.processWatermark1(new Watermark(Long.MAX_VALUE));
        operator.processWatermark2(new Watermark(Long.MAX_VALUE));
    }

    public void processElement1(StreamRecord<IterationRecord<IN1>> element) throws Exception {
        this.processElement(element, 0, this.reusedInput1, record -> ((TwoInputStreamOperator)this.getWrappedOperator(((IterationRecord)element.getValue()).getEpoch())).processElement1(record));
    }

    public void processElement2(StreamRecord<IterationRecord<IN2>> element) throws Exception {
        this.processElement(element, 1, this.reusedInput2, record -> ((TwoInputStreamOperator)this.getWrappedOperator(((IterationRecord)element.getValue()).getEpoch())).processElement2(record));
    }

    private <IN> void processElement(StreamRecord<IterationRecord<IN>> element, int inputIndex, StreamRecord<IN> reusedInput, ThrowingConsumer<StreamRecord<IN>, Exception> processor) throws Exception {
        switch (((IterationRecord)element.getValue()).getType()) {
            case RECORD: {
                reusedInput.replace(((IterationRecord)element.getValue()).getValue(), element.getTimestamp());
                this.setIterationContextRound(((IterationRecord)element.getValue()).getEpoch());
                processor.accept(reusedInput);
                this.clearIterationContextRound();
                break;
            }
            case EPOCH_WATERMARK: {
                this.onEpochWatermarkEvent(inputIndex, (IterationRecord)element.getValue());
                break;
            }
            default: {
                throw new FlinkRuntimeException("Not supported iteration record type: " + element);
            }
        }
    }

    public void processWatermark1(Watermark mark) throws Exception {
        this.processForEachWrappedOperator((round, wrappedOperator) -> wrappedOperator.processWatermark1(mark));
    }

    public void processWatermark2(Watermark mark) throws Exception {
        this.processForEachWrappedOperator((round, wrappedOperator) -> wrappedOperator.processWatermark2(mark));
    }

    public void processLatencyMarker1(LatencyMarker latencyMarker) throws Exception {
        this.reportOrForwardLatencyMarker(latencyMarker);
    }

    public void processLatencyMarker2(LatencyMarker latencyMarker) throws Exception {
        this.reportOrForwardLatencyMarker(latencyMarker);
    }

    public void processWatermarkStatus1(WatermarkStatus watermarkStatus) throws Exception {
        this.processForEachWrappedOperator((round, wrappedOperator) -> wrappedOperator.processWatermarkStatus1(watermarkStatus));
    }

    public void processWatermarkStatus2(WatermarkStatus watermarkStatus) throws Exception {
        this.processForEachWrappedOperator((round, wrappedOperator) -> wrappedOperator.processWatermarkStatus2(watermarkStatus));
    }
}

