/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.ml.builder.GraphNode;
import org.apache.flink.ml.builder.TableId;
import org.apache.flink.util.Preconditions;

public class GraphData {
    public final List<GraphNode> nodes;
    @Nullable
    public final TableId[] estimatorInputIds;
    public final TableId[] modelInputIds;
    public final TableId[] outputIds;
    @Nullable
    public final TableId[] inputModelDataIds;
    @Nullable
    public final TableId[] outputModelDataIds;

    public GraphData(List<GraphNode> nodes, TableId[] estimatorInputIds, TableId[] modelInputIds, TableId[] outputIds, TableId[] inputModelDataIds, TableId[] outputModelDataIds) {
        this.nodes = (List)Preconditions.checkNotNull(nodes);
        this.estimatorInputIds = estimatorInputIds;
        this.modelInputIds = (TableId[])Preconditions.checkNotNull((Object)modelInputIds);
        this.outputIds = (TableId[])Preconditions.checkNotNull((Object)outputIds);
        this.inputModelDataIds = inputModelDataIds;
        this.outputModelDataIds = outputModelDataIds;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> nodeInfos = new ArrayList<Map<String, Object>>();
        for (GraphNode node : this.nodes) {
            nodeInfos.add(node.toMap());
        }
        result.put("nodes", nodeInfos);
        if (this.estimatorInputIds != null) {
            result.put("estimatorInputIds", TableId.toList(this.estimatorInputIds));
        }
        result.put("modelInputIds", TableId.toList(this.modelInputIds));
        result.put("outputIds", TableId.toList(this.outputIds));
        if (this.inputModelDataIds != null) {
            result.put("inputModelDataIds", TableId.toList(this.inputModelDataIds));
        }
        if (this.outputModelDataIds != null) {
            result.put("outputModelDataIds", TableId.toList(this.outputModelDataIds));
        }
        return result;
    }

    public static GraphData fromMap(Map<String, Object> map) {
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        List nodeInfos = (List)map.get("nodes");
        for (Map nodeInfo : nodeInfos) {
            nodes.add(GraphNode.fromMap(nodeInfo));
        }
        TableId[] estimatorInputIds = null;
        if (map.containsKey("estimatorInputIds")) {
            estimatorInputIds = TableId.fromList((List)map.get("estimatorInputIds"));
        }
        TableId[] modelInputIds = TableId.fromList((List)map.get("modelInputIds"));
        TableId[] outputIds = TableId.fromList((List)map.get("outputIds"));
        TableId[] inputModelDataIds = null;
        if (map.containsKey("inputModelDataIds")) {
            inputModelDataIds = TableId.fromList((List)map.get("inputModelDataIds"));
        }
        TableId[] outputModelDataIds = null;
        if (map.containsKey("outputModelDataIds")) {
            outputModelDataIds = TableId.fromList((List)map.get("outputModelDataIds"));
        }
        return new GraphData(nodes, estimatorInputIds, modelInputIds, outputIds, inputModelDataIds, outputModelDataIds);
    }
}

