/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.countvectorizer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.array.StringArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class CountVectorizerModelData {
    public String[] vocabulary;

    public CountVectorizerModelData() {
    }

    public CountVectorizerModelData(String[] vocabulary) {
        this.vocabulary = vocabulary;
    }

    public static DataStream<CountVectorizerModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new CountVectorizerModelData((String[])x.getField(0)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<CountVectorizerModelData> {
        public StreamFormat.Reader<CountVectorizerModelData> createReader(Configuration configuration, final FSDataInputStream fsDataInputStream) {
            return new StreamFormat.Reader<CountVectorizerModelData>(){

                public CountVectorizerModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)fsDataInputStream);
                    try {
                        String[] vocabulary = StringArraySerializer.INSTANCE.deserialize((DataInputView)source);
                        return new CountVectorizerModelData(vocabulary);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    fsDataInputStream.close();
                }
            };
        }

        public TypeInformation<CountVectorizerModelData> getProducedType() {
            return TypeInformation.of(CountVectorizerModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<CountVectorizerModelData> {
        public void encode(CountVectorizerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            StringArraySerializer.INSTANCE.serialize(modelData.vocabulary, (DataOutputView)dataOutputView);
        }
    }
}

