/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.minmaxscaler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.minmaxscaler.MinMaxScalerModelData;
import org.apache.flink.ml.feature.minmaxscaler.MinMaxScalerParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class MinMaxScalerModel
implements Model<MinMaxScalerModel>,
MinMaxScalerParams<MinMaxScalerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public MinMaxScalerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public MinMaxScalerModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream data = tEnv.toDataStream(inputs[0]);
        DataStream<MinMaxScalerModelData> minMaxScalerModel = MinMaxScalerModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{TypeInformation.of(DenseVector.class)}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(data), Collections.singletonMap("broadcastModelKey", minMaxScalerModel), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new PredictOutputFunction("broadcastModelKey", this.getMax(), this.getMin(), this.getInputCol()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(MinMaxScalerModelData.getModelDataStream(this.modelDataTable), path, new MinMaxScalerModelData.ModelDataEncoder());
    }

    public static MinMaxScalerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        MinMaxScalerModel model = (MinMaxScalerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new MinMaxScalerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String inputCol;
        private final String broadcastKey;
        private final double upperBound;
        private final double lowerBound;
        private DenseVector scaleVector;
        private DenseVector offsetVector;

        public PredictOutputFunction(String broadcastKey, double upperBound, double lowerBound, String inputCol) {
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
            this.broadcastKey = broadcastKey;
            this.inputCol = inputCol;
        }

        public Row map(Row row) {
            if (this.scaleVector == null) {
                MinMaxScalerModelData minMaxScalerModelData = (MinMaxScalerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                DenseVector minVector = minMaxScalerModelData.minVector;
                DenseVector maxVector = minMaxScalerModelData.maxVector;
                this.scaleVector = new DenseVector(minVector.size());
                this.offsetVector = new DenseVector(minVector.size());
                for (int i = 0; i < maxVector.size(); ++i) {
                    if (Math.abs(minVector.values[i] - maxVector.values[i]) < 1.0E-5) {
                        this.scaleVector.values[i] = 0.0;
                        this.offsetVector.values[i] = (this.upperBound + this.lowerBound) / 2.0;
                        continue;
                    }
                    this.scaleVector.values[i] = (this.upperBound - this.lowerBound) / (maxVector.values[i] - minVector.values[i]);
                    this.offsetVector.values[i] = this.lowerBound - minVector.values[i] * this.scaleVector.values[i];
                }
            }
            DenseVector inputVec = ((Vector)row.getField(this.inputCol)).toDense();
            DenseVector outputVec = new DenseVector(this.scaleVector.size());
            for (int i = 0; i < this.scaleVector.size(); ++i) {
                outputVec.values[i] = inputVec.values[i] * this.scaleVector.values[i] + this.offsetVector.values[i];
            }
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

