/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.vectorassembler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.vectorassembler.VectorAssemblerParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class VectorAssembler
implements Transformer<VectorAssembler>,
VectorAssemblerParams<VectorAssembler> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private static final double RATIO = 1.5;

    public VectorAssembler() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getInputSizes().length == this.getInputCols().length ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).flatMap((FlatMapFunction)new AssemblerFunction(this.getInputCols(), this.getHandleInvalid(), this.getInputSizes()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static VectorAssembler load(StreamTableEnvironment env, String path) throws IOException {
        return (VectorAssembler)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static Vector assembleDense(String[] inputCols, Row inputRow, int vectorSize) {
        double[] values = new double[vectorSize];
        int currentOffset = 0;
        for (String inputCol : inputCols) {
            Object object = inputRow.getField(inputCol);
            if (object instanceof Number) {
                values[currentOffset++] = ((Number)object).doubleValue();
                continue;
            }
            if (object instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)object;
                for (int i = 0; i < sparseVector.indices.length; ++i) {
                    values[currentOffset + sparseVector.indices[i]] = sparseVector.values[i];
                }
                currentOffset += sparseVector.size();
                continue;
            }
            DenseVector denseVector = (DenseVector)object;
            System.arraycopy(denseVector.values, 0, values, currentOffset, denseVector.size());
            currentOffset += denseVector.size();
        }
        return Vectors.dense(values);
    }

    private static Vector assembleSparse(String[] inputCols, Row inputRow, int vectorSize, int nnz) {
        int[] indices = new int[nnz];
        double[] values = new double[nnz];
        int currentIndex = 0;
        int currentOffset = 0;
        for (String inputCol : inputCols) {
            int i;
            Object object = inputRow.getField(inputCol);
            if (object instanceof Number) {
                indices[currentOffset] = currentIndex++;
                values[currentOffset] = ((Number)object).doubleValue();
                ++currentOffset;
                continue;
            }
            if (object instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)object;
                for (i = 0; i < sparseVector.indices.length; ++i) {
                    indices[currentOffset + i] = sparseVector.indices[i] + currentIndex;
                }
                System.arraycopy(sparseVector.values, 0, values, currentOffset, sparseVector.values.length);
                currentIndex += sparseVector.size();
                currentOffset += sparseVector.indices.length;
                continue;
            }
            DenseVector denseVector = (DenseVector)object;
            for (i = 0; i < denseVector.size(); ++i) {
                indices[currentOffset + i] = i + currentIndex;
            }
            System.arraycopy(denseVector.values, 0, values, currentOffset, denseVector.values.length);
            currentIndex += denseVector.size();
            currentOffset += denseVector.size();
        }
        return new SparseVector(vectorSize, indices, values);
    }

    private static class AssemblerFunction
    implements FlatMapFunction<Row, Row> {
        private final String[] inputCols;
        private final String handleInvalid;
        private final Integer[] inputSizes;
        private final boolean keepInvalid;

        public AssemblerFunction(String[] inputCols, String handleInvalid, Integer[] inputSizes) {
            this.inputCols = inputCols;
            this.handleInvalid = handleInvalid;
            this.inputSizes = inputSizes;
            this.keepInvalid = handleInvalid.equals("keep");
        }

        public void flatMap(Row value, Collector<Row> out) {
            block2: {
                try {
                    Tuple2<Integer, Integer> vectorSizeAndNnz = this.computeVectorSizeAndNnz(value);
                    int vectorSize = (Integer)vectorSizeAndNnz.f0;
                    int nnz = (Integer)vectorSizeAndNnz.f1;
                    Vector assembledVec = (double)nnz * 1.5 > (double)vectorSize ? VectorAssembler.assembleDense(this.inputCols, value, vectorSize) : VectorAssembler.assembleSparse(this.inputCols, value, vectorSize, nnz);
                    out.collect((Object)Row.join((Row)value, (Row[])new Row[]{Row.of((Object[])new Object[]{assembledVec})}));
                }
                catch (Exception e) {
                    if (!this.handleInvalid.equals("error")) break block2;
                    throw new RuntimeException("Vector assembler failed with exception : " + e);
                }
            }
        }

        private Tuple2<Integer, Integer> computeVectorSizeAndNnz(Row value) {
            int vectorSize = 0;
            int nnz = 0;
            for (int i = 0; i < this.inputCols.length; ++i) {
                Object object = value.getField(this.inputCols[i]);
                if (object != null) {
                    if (object instanceof Number) {
                        this.checkSize(this.inputSizes[i], 1);
                        if (Double.isNaN(((Number)object).doubleValue()) && !this.keepInvalid) {
                            throw new RuntimeException("Encountered NaN while assembling a row with handleInvalid = 'error'. Consider removing NaNs from dataset or using handleInvalid = 'keep' or 'skip'.");
                        }
                        ++vectorSize;
                        ++nnz;
                        continue;
                    }
                    if (object instanceof SparseVector) {
                        int localSize = ((SparseVector)object).size();
                        this.checkSize(this.inputSizes[i], localSize);
                        nnz += ((SparseVector)object).indices.length;
                        vectorSize += localSize;
                        continue;
                    }
                    if (object instanceof DenseVector) {
                        int localSize = ((DenseVector)object).size();
                        this.checkSize(this.inputSizes[i], localSize);
                        vectorSize += localSize;
                        nnz += ((DenseVector)object).size();
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Input type %s has not been supported yet. Only Vector and Number types are supported.", object.getClass()));
                }
                vectorSize += this.inputSizes[i].intValue();
                nnz += this.inputSizes[i].intValue();
                if (this.keepInvalid) {
                    if (this.inputSizes[i] > 1) {
                        DenseVector tmpVec = new DenseVector(this.inputSizes[i]);
                        for (int j = 0; j < this.inputSizes[i]; ++j) {
                            tmpVec.values[j] = Double.NaN;
                        }
                        value.setField(this.inputCols[i], (Object)tmpVec);
                        continue;
                    }
                    value.setField(this.inputCols[i], (Object)Double.NaN);
                    continue;
                }
                throw new RuntimeException("Input column value is null. Please check the input data or using handleInvalid = 'keep'.");
            }
            return Tuple2.of((Object)vectorSize, (Object)nnz);
        }

        private void checkSize(int expectedSize, int currentSize) {
            if (this.keepInvalid) {
                return;
            }
            if (currentSize != expectedSize) {
                throw new IllegalArgumentException(String.format("Input vector/number size does not meet with expected. Expected size: %d, actual size: %s.", expectedSize, currentSize));
            }
        }
    }
}

