/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.vectorindexer;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.vectorindexer.VectorIndexerModelData;
import org.apache.flink.ml.feature.vectorindexer.VectorIndexerModelParams;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class VectorIndexerModel
implements Model<VectorIndexerModel>,
VectorIndexerModelParams<VectorIndexerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public VectorIndexerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String inputCol = this.getInputCol();
        String outputCol = this.getOutputCol();
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)this.modelDataTable).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{outputCol}));
        String broadcastModelKey = "broadcastModelKey";
        DataStream<VectorIndexerModelData> modelDataStream = VectorIndexerModelData.getModelDataStream(this.modelDataTable);
        DataStream result = BroadcastUtils.withBroadcastStream(Collections.singletonList(tEnv.toDataStream(inputs[0])), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.flatMap((FlatMapFunction)new FindIndex("broadcastModelKey", inputCol, this.getHandleInvalid()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(result)};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(VectorIndexerModelData.getModelDataStream(this.modelDataTable), path, new VectorIndexerModelData.ModelDataEncoder());
    }

    public static VectorIndexerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        VectorIndexerModel model = (VectorIndexerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new VectorIndexerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public VectorIndexerModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    private static Integer getMapping(double feature, Map<Double, Integer> mapping, String handleInValid) {
        if (mapping.containsKey(feature)) {
            return mapping.get(feature);
        }
        switch (handleInValid) {
            case "skip": {
                return null;
            }
            case "error": {
                throw new RuntimeException("The input contains unseen double: " + feature + ". See " + HANDLE_INVALID + " parameter for more options.");
            }
            case "keep": {
                return mapping.size();
            }
        }
        throw new UnsupportedOperationException("Unsupported " + HANDLE_INVALID + "type: " + handleInValid);
    }

    private static class FindIndex
    extends RichFlatMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final String inputCol;
        private final String handleInValid;
        private Map<Integer, Map<Double, Integer>> categoryMaps;

        public FindIndex(String broadcastModelKey, String inputCol, String handleInValid) {
            this.broadcastModelKey = broadcastModelKey;
            this.inputCol = inputCol;
            this.handleInValid = handleInValid;
        }

        public void flatMap(Row input, Collector<Row> out) {
            if (this.categoryMaps == null) {
                VectorIndexerModelData modelData = (VectorIndexerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.categoryMaps = modelData.categoryMaps;
            }
            Vector outputVector = ((Vector)input.getField(this.inputCol)).clone();
            for (Map.Entry<Integer, Map<Double, Integer>> entry : this.categoryMaps.entrySet()) {
                int columnId = entry.getKey();
                Map<Double, Integer> mapping = entry.getValue();
                double feature = outputVector.get(columnId);
                Integer categoricalFeature = VectorIndexerModel.getMapping(feature, mapping, this.handleInValid);
                if (categoricalFeature == null) {
                    return;
                }
                outputVector.set(columnId, categoricalFeature.intValue());
            }
            out.collect((Object)Row.join((Row)input, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVector})}));
        }
    }
}

