/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.backpressure;

import java.util.concurrent.TimeUnit;
import org.apache.flink.statefun.flink.core.backpressure.Timer;

final class SystemNanoTimer
implements Timer {
    private static final SystemNanoTimer INSTANCE = new SystemNanoTimer();

    public static SystemNanoTimer instance() {
        return INSTANCE;
    }

    private SystemNanoTimer() {
    }

    @Override
    public long now() {
        return System.nanoTime();
    }

    @Override
    public void sleep(long sleepTimeNanos) {
        try {
            long sleepTimeMs = TimeUnit.NANOSECONDS.toMillis(sleepTimeNanos);
            Thread.sleep(sleepTimeMs);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted while sleeping", ex);
        }
    }
}

