/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;

public final class DefaultHttpRequestReplyClientSpec {
    @JsonProperty(value="timeouts")
    private Timeouts timeouts = new Timeouts();

    @JsonSetter(value="timeouts")
    public void setTimeouts(Timeouts timeouts) {
        DefaultHttpRequestReplyClientSpec.validateTimeouts(timeouts.callTimeout, timeouts.connectTimeout, timeouts.readTimeout, timeouts.writeTimeout);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public ObjectNode toJson(ObjectMapper objectMapper) {
        return (ObjectNode)objectMapper.valueToTree((Object)this);
    }

    static DefaultHttpRequestReplyClientSpec fromJson(ObjectMapper objectMapper, JsonNode jsonNode) throws JsonProcessingException {
        return (DefaultHttpRequestReplyClientSpec)objectMapper.treeToValue((TreeNode)jsonNode, DefaultHttpRequestReplyClientSpec.class);
    }

    private static void validateTimeouts(Duration callTimeout, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        if (connectTimeout.compareTo(callTimeout) > 0) {
            throw new IllegalArgumentException("Connect timeout cannot be larger than request timeout.");
        }
        if (readTimeout.compareTo(callTimeout) > 0) {
            throw new IllegalArgumentException("Read timeout cannot be larger than request timeout.");
        }
        if (writeTimeout.compareTo(callTimeout) > 0) {
            throw new IllegalArgumentException("Write timeout cannot be larger than request timeout.");
        }
    }

    public static final class Timeouts {
        private static final Duration DEFAULT_HTTP_TIMEOUT = Duration.ofMinutes(1L);
        private static final Duration DEFAULT_HTTP_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
        private static final Duration DEFAULT_HTTP_READ_TIMEOUT = Duration.ofSeconds(10L);
        private static final Duration DEFAULT_HTTP_WRITE_TIMEOUT = Duration.ofSeconds(10L);
        private Duration callTimeout = DEFAULT_HTTP_TIMEOUT;
        private Duration connectTimeout = DEFAULT_HTTP_CONNECT_TIMEOUT;
        private Duration readTimeout = DEFAULT_HTTP_READ_TIMEOUT;
        private Duration writeTimeout = DEFAULT_HTTP_WRITE_TIMEOUT;

        @JsonSetter(value="call")
        public void setCallTimeout(Duration callTimeout) {
            this.callTimeout = Timeouts.requireNonZeroDuration(callTimeout);
        }

        @JsonSetter(value="connect")
        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = Timeouts.requireNonZeroDuration(connectTimeout);
        }

        @JsonSetter(value="read")
        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = Timeouts.requireNonZeroDuration(readTimeout);
        }

        @JsonSetter(value="write")
        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = Timeouts.requireNonZeroDuration(writeTimeout);
        }

        public Duration getCallTimeout() {
            return this.callTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public Duration getWriteTimeout() {
            return this.writeTimeout;
        }

        private static Duration requireNonZeroDuration(Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.equals(Duration.ZERO)) {
                throw new IllegalArgumentException("Timeout durations must be larger than 0.");
            }
            return duration;
        }
    }
}

