/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn.binders.v2;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.statefun.extensions.ComponentBinder;
import org.apache.flink.statefun.extensions.ComponentJsonObject;
import org.apache.flink.statefun.flink.common.json.StateFunObjectMapper;
import org.apache.flink.statefun.flink.core.httpfn.HttpFunctionEndpointSpec;
import org.apache.flink.statefun.flink.core.httpfn.HttpFunctionProvider;
import org.apache.flink.statefun.flink.core.httpfn.TargetFunctions;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClientFactory;
import org.apache.flink.statefun.flink.core.spi.ExtensionResolver;
import org.apache.flink.statefun.flink.core.spi.ExtensionResolverAccessor;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;
import org.apache.flink.statefun.sdk.TypeName;
import org.apache.flink.statefun.sdk.spi.StatefulFunctionModule;

final class HttpEndpointBinderV2
implements ComponentBinder {
    private static final ObjectMapper SPEC_OBJ_MAPPER = StateFunObjectMapper.create();
    static final HttpEndpointBinderV2 INSTANCE = new HttpEndpointBinderV2();
    static final TypeName KIND_TYPE = TypeName.parseFrom((String)"io.statefun.endpoints.v2/http");

    private HttpEndpointBinderV2() {
    }

    public void bind(ComponentJsonObject component, StatefulFunctionModule.Binder binder) {
        HttpEndpointBinderV2.validateComponent(component);
        HttpFunctionEndpointSpec spec = HttpEndpointBinderV2.parseSpec(component);
        HttpFunctionProvider provider = HttpEndpointBinderV2.functionProvider(spec, ExtensionResolverAccessor.getExtensionResolver(binder));
        TargetFunctions target = spec.targetFunctions();
        if (target.isSpecificFunctionType()) {
            binder.bindFunctionProvider(target.asSpecificFunctionType(), (StatefulFunctionProvider)provider);
        } else {
            binder.bindFunctionProvider(target.asNamespace(), (StatefulFunctionProvider)provider);
        }
    }

    private static void validateComponent(ComponentJsonObject componentJsonObject) {
        TypeName targetBinderType = componentJsonObject.binderTypename();
        if (!targetBinderType.equals((Object)KIND_TYPE)) {
            throw new IllegalStateException("Received unexpected ModuleComponent to bind: " + componentJsonObject);
        }
    }

    private static HttpFunctionEndpointSpec parseSpec(ComponentJsonObject component) {
        try {
            return (HttpFunctionEndpointSpec)SPEC_OBJ_MAPPER.treeToValue((TreeNode)component.specJsonNode(), HttpFunctionEndpointSpec.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error parsing a HttpFunctionEndpointSpec.", e);
        }
    }

    private static HttpFunctionProvider functionProvider(HttpFunctionEndpointSpec spec, ExtensionResolver extensionResolver) {
        RequestReplyClientFactory transportClientFactory = extensionResolver.resolveExtension(spec.transportClientFactoryType(), RequestReplyClientFactory.class);
        return new HttpFunctionProvider(spec, transportClientFactory);
    }
}

