/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.FactoryUtil;

public class FlinkConnectorOptions {
    public static final String TABLE_STORE_PREFIX = "table-store.";
    public static final String NONE = "none";
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    @Internal
    public static final ConfigOption<String> ROOT_PATH = ConfigOptions.key((String)"root-path").stringType().noDefaultValue().withDescription("The root file path of the table store in the filesystem.");
    public static final ConfigOption<String> LOG_SYSTEM = ConfigOptions.key((String)"log.system").stringType().defaultValue((Object)"none").withDescription(Description.builder().text("The log system used to keep changes of the table.").linebreak().linebreak().text("Possible values:").linebreak().list(new InlineElement[]{TextElement.text((String)"\"none\": No log system, the data is written only to file store, and the streaming read will be directly read from the file store.")}).list(new InlineElement[]{TextElement.text((String)"\"kafka\": Kafka log system, the data is double written to file store and kafka, and the streaming read will be read from kafka.")}).build());
    public static final ConfigOption<Integer> SINK_PARALLELISM = FactoryUtil.SINK_PARALLELISM;
    public static final ConfigOption<Integer> SCAN_PARALLELISM = ConfigOptions.key((String)"scan.parallelism").intType().noDefaultValue().withDescription("Define a custom parallelism for the scan source. By default, if this option is not defined, the planner will derive the parallelism for each statement individually by also considering the global configuration.");

    public static String relativeTablePath(ObjectIdentifier tableIdentifier) {
        return String.format("%s.catalog/%s.db/%s", tableIdentifier.getCatalogName(), tableIdentifier.getDatabaseName(), tableIdentifier.getObjectName());
    }

    @Internal
    public static List<ConfigOption<?>> getOptions() {
        Field[] fields = FlinkConnectorOptions.class.getFields();
        ArrayList list = new ArrayList(fields.length);
        for (Field field : fields) {
            if (!ConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                list.add((ConfigOption)field.get(FlinkConnectorOptions.class));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }
}

