/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.metrics.internals;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MetricsUtils {
    public static double convert(long timeMs, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return (double)timeMs * 1000.0 * 1000.0;
            }
            case MICROSECONDS: {
                return (double)timeMs * 1000.0;
            }
            case MILLISECONDS: {
                return timeMs;
            }
            case SECONDS: {
                return (double)timeMs / 1000.0;
            }
            case MINUTES: {
                return (double)timeMs / 60000.0;
            }
            case HOURS: {
                return (double)timeMs / 3600000.0;
            }
            case DAYS: {
                return (double)timeMs / 8.64E7;
            }
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)unit));
    }

    public static Map<String, String> getTags(String ... keyValue) {
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("keyValue needs to be specified in pairs");
        }
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(keyValue.length / 2);
        for (int i = 0; i < keyValue.length; i += 2) {
            tags.put(keyValue[i], keyValue[i + 1]);
        }
        return tags;
    }
}

