/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.Preconditions;

@Internal
class WatermarkQueueEntry<OUT>
implements StreamElementQueueEntry<OUT> {
    @Nonnull
    private final Watermark watermark;

    WatermarkQueueEntry(Watermark watermark) {
        this.watermark = Preconditions.checkNotNull(watermark);
    }

    @Override
    public void emitResult(TimestampedCollector<OUT> output) {
        output.emitWatermark(this.watermark);
    }

    @Override
    @Nonnull
    public Watermark getInputElement() {
        return this.watermark;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void complete(Collection result) {
        throw new IllegalStateException("Cannot complete a watermark.");
    }
}

