/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;

@Internal
public final class LiteralArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final boolean allowNull;

    public LiteralArgumentTypeStrategy(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        if (!callContext.isArgumentLiteral(argumentPos)) {
            return callContext.fail(throwOnFailure, "Literal expected.", new Object[0]);
        }
        if (callContext.isArgumentNull(argumentPos) && !this.allowNull) {
            return callContext.fail(throwOnFailure, "Literal must not be NULL.", new Object[0]);
        }
        return Optional.of(callContext.getArgumentDataTypes().get(argumentPos));
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        if (this.allowNull) {
            return Signature.Argument.ofGroup("LITERAL");
        }
        return Signature.Argument.ofGroup("LITERAL NOT NULL");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralArgumentTypeStrategy that = (LiteralArgumentTypeStrategy)o;
        return this.allowNull == that.allowNull;
    }

    public int hashCode() {
        return Objects.hash(this.allowNull);
    }
}

