/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.ArrayList;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.Statistic;
import org.apache.geode.admin.StatisticResource;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.internal.StatisticImpl;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatResource;

@Deprecated
public class StatisticResourceImpl
implements StatisticResource {
    protected StatResource statResource;
    protected String name;
    protected String description;
    protected String type;
    protected SystemMember member;
    protected Statistic[] statistics;

    public StatisticResourceImpl(StatResource statResource, SystemMember member) throws AdminException {
        this.statResource = statResource;
        this.member = member;
        this.name = this.statResource.getName();
        this.description = this.statResource.getDescription();
        this.type = this.statResource.getType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getOwner() {
        return this.member.toString();
    }

    @Override
    public Statistic[] getStatistics() {
        if (this.statistics == null) {
            try {
                this.refresh();
            }
            catch (AdminException e) {
                this.statistics = new Statistic[0];
            }
        }
        return this.statistics;
    }

    @Override
    public long getUniqueId() {
        return this.statResource.getResourceUniqueID();
    }

    @Override
    public void refresh() throws AdminException {
        Stat[] stats = null;
        if (this.statResource != null) {
            stats = this.statResource.getStats();
        }
        if (stats == null || stats.length < 1) {
            throw new AdminException(String.format("Failed to refresh statistics %s for %s", this.getType() + "-" + this.getName(), this.getOwner()));
        }
        if (this.statistics == null || this.statistics.length < 1) {
            ArrayList<Statistic> statList = new ArrayList<Statistic>();
            for (Stat stat : stats) {
                statList.add(this.createStatistic(stat));
            }
            this.statistics = statList.toArray(new Statistic[0]);
        } else {
            for (Stat stat : stats) {
                this.updateStatistic(stat);
            }
        }
    }

    private void updateStatistic(Stat stat) {
        for (Statistic statistic : this.statistics) {
            if (!statistic.getName().equals(stat.getName())) continue;
            ((StatisticImpl)statistic).setStat(stat);
            return;
        }
        Assert.assertTrue(false, "Unknown stat: " + stat.getName());
    }

    protected Statistic createStatistic(Stat stat) {
        return new StatisticImpl(stat);
    }

    public String toString() {
        return this.getName();
    }
}

