/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.PdxRegistryRecoveryListener;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.ServerLocationAndMemberId;
import org.apache.geode.internal.cache.PoolStats;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class EndpointManagerImpl
implements EndpointManager {
    private static final Logger logger = LogService.getLogger();
    private static final Logger secureLogger = LogService.getLogger((String)"org.apache.geode.security");
    private volatile Map<ServerLocationAndMemberId, Endpoint> endpointMap = Collections.emptyMap();
    private final Map<ServerLocationAndMemberId, ConnectionStats> statMap = new HashMap<ServerLocationAndMemberId, ConnectionStats>();
    private final DistributedSystem ds;
    private final String poolName;
    private final EndpointListenerBroadcaster listener = new EndpointListenerBroadcaster();
    protected final CancelCriterion cancelCriterion;
    private final PoolStats poolStats;

    public EndpointManagerImpl(String poolName, DistributedSystem ds, CancelCriterion cancelCriterion, PoolStats poolStats) {
        this.ds = ds;
        this.poolName = poolName;
        this.cancelCriterion = cancelCriterion;
        this.poolStats = poolStats;
        this.listener.addListener(new EndpointListenerForBridgeMembership());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint referenceEndpoint(ServerLocation server, DistributedMember memberId) {
        ServerLocationAndMemberId serverLocationAndMemberId = new ServerLocationAndMemberId(server, memberId.getUniqueId());
        Endpoint endpoint = this.endpointMap.get(serverLocationAndMemberId);
        boolean addedEndpoint = false;
        if (endpoint == null || endpoint.isClosed()) {
            EndpointManagerImpl endpointManagerImpl = this;
            synchronized (endpointManagerImpl) {
                endpoint = this.endpointMap.get(serverLocationAndMemberId);
                if (endpoint == null || endpoint.isClosed()) {
                    ConnectionStats stats = this.getStats(serverLocationAndMemberId);
                    HashMap<ServerLocationAndMemberId, Endpoint> endpointMapTemp = new HashMap<ServerLocationAndMemberId, Endpoint>(this.endpointMap);
                    endpoint = new Endpoint(this, this.ds, server, stats, memberId);
                    this.listener.clearPdxRegistry(endpoint);
                    endpointMapTemp.put(serverLocationAndMemberId, endpoint);
                    this.endpointMap = Collections.unmodifiableMap(endpointMapTemp);
                    addedEndpoint = true;
                    this.poolStats.setServerCount(this.endpointMap.size());
                }
            }
        }
        endpoint.addReference();
        if (addedEndpoint) {
            this.listener.endpointNowInUse(endpoint);
        }
        return endpoint;
    }

    @Override
    public void serverCrashed(Endpoint endpoint) {
        this.removeEndpoint(endpoint, true);
    }

    void endpointNotInUse(Endpoint endpoint) {
        this.removeEndpoint(endpoint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEndpoint(Endpoint endpoint, boolean crashed) {
        endpoint.close();
        boolean removedEndpoint = false;
        EndpointManagerImpl endpointManagerImpl = this;
        synchronized (endpointManagerImpl) {
            HashMap<ServerLocationAndMemberId, Endpoint> endpointMapTemp = new HashMap<ServerLocationAndMemberId, Endpoint>(this.endpointMap);
            endpoint = (Endpoint)endpointMapTemp.remove(new ServerLocationAndMemberId(endpoint.getLocation(), endpoint.getMemberId().getUniqueId()));
            if (endpoint != null) {
                this.endpointMap = Collections.unmodifiableMap(endpointMapTemp);
                removedEndpoint = true;
            }
            this.poolStats.setServerCount(this.endpointMap.size());
        }
        if (removedEndpoint) {
            PoolImpl pool = (PoolImpl)PoolManager.find(this.poolName);
            ServerLocation location = endpoint.getLocation();
            if (pool != null && pool.getMultiuserAuthentication()) {
                Long userId;
                ArrayList<ProxyCache> proxyCaches;
                int size = 0;
                ArrayList<ProxyCache> arrayList = proxyCaches = pool.getProxyCacheList();
                synchronized (arrayList) {
                    for (ProxyCache proxyCache : proxyCaches) {
                        try {
                            Long userId2 = proxyCache.getUserAttributes().getServerToId().remove(location);
                            if (userId2 == null) continue;
                            ++size;
                        }
                        catch (CacheClosedException cacheClosedException) {}
                    }
                    secureLogger.debug("EndpointManagerImpl.removeEndpoint() Removed server {} from {} user's ProxyCache", (Object)location, (Object)size);
                }
                UserAttributes ua = UserAttributes.userAttributes.get();
                if (ua != null && (userId = ua.getServerToId().remove(location)) != null) {
                    secureLogger.debug("EndpointManagerImpl.removeEndpoint() Removed server {} from thread local variable", (Object)location);
                }
            } else if (pool != null && !pool.getMultiuserAuthentication()) {
                secureLogger.debug("set the userId of {} to -1", (Object)location);
                location.setUserId(-1L);
            }
            if (crashed) {
                this.listener.endpointCrashed(endpoint);
            } else {
                this.listener.endpointNoLongerInUse(endpoint);
            }
        }
    }

    @Override
    public Map<ServerLocationAndMemberId, Endpoint> getEndpointMap() {
        return this.endpointMap;
    }

    @Override
    public synchronized void close() {
        for (ConnectionStats stats : this.statMap.values()) {
            stats.close();
        }
        this.statMap.clear();
        this.endpointMap = Collections.emptyMap();
        this.listener.clear();
    }

    @Override
    public void addListener(EndpointManager.EndpointListener listener) {
        this.listener.addListener(listener);
    }

    @Override
    public void removeListener(EndpointManager.EndpointListener listener) {
        this.listener.removeListener(listener);
    }

    @VisibleForTesting
    public Set<EndpointManager.EndpointListener> getListeners() {
        return this.listener.endpointListeners;
    }

    private synchronized ConnectionStats getStats(ServerLocationAndMemberId location) {
        ConnectionStats stats = this.statMap.get(location);
        if (stats == null) {
            String statName;
            PoolImpl pool = (PoolImpl)PoolManager.find(this.poolName);
            if (pool != null && pool.getGatewaySender() != null) {
                statName = pool.getGatewaySender().getId() + "-" + location.toString();
                stats = new ConnectionStats(this.ds, "GatewaySender", statName, this.poolStats);
            }
            if (stats == null) {
                statName = this.poolName + "-" + location.toString();
                stats = new ConnectionStats(this.ds, "Client", statName, this.poolStats);
            }
            this.statMap.put(location, stats);
        }
        return stats;
    }

    @Override
    public synchronized Map<ServerLocationAndMemberId, ConnectionStats> getAllStats() {
        return new HashMap<ServerLocationAndMemberId, ConnectionStats>(this.statMap);
    }

    @Override
    public int getConnectedServerCount() {
        return this.getEndpointMap().size();
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public class EndpointListenerForBridgeMembership
    implements EndpointManager.EndpointListener {
        @Override
        public void endpointCrashed(Endpoint endpoint) {
            if (EndpointManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                return;
            }
            InternalClientMembership.notifyServerCrashed(endpoint.getLocation());
        }

        @Override
        public void endpointNoLongerInUse(Endpoint endpoint) {
            if (EndpointManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                return;
            }
            InternalClientMembership.notifyServerLeft(endpoint.getLocation());
        }

        @Override
        public void endpointNowInUse(Endpoint endpoint) {
            if (EndpointManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                return;
            }
            InternalClientMembership.notifyServerJoined(endpoint.getLocation());
        }
    }

    protected static class EndpointListenerBroadcaster
    implements EndpointManager.EndpointListener {
        private volatile Set<EndpointManager.EndpointListener> endpointListeners = Collections.emptySet();

        protected EndpointListenerBroadcaster() {
        }

        public synchronized void addListener(EndpointManager.EndpointListener listener) {
            HashSet<EndpointManager.EndpointListener> tmpListeners = new HashSet<EndpointManager.EndpointListener>(this.endpointListeners);
            tmpListeners.add(listener);
            this.endpointListeners = Collections.unmodifiableSet(tmpListeners);
        }

        public synchronized void clear() {
            this.endpointListeners = Collections.emptySet();
        }

        public void removeListener(EndpointManager.EndpointListener listener) {
            HashSet<EndpointManager.EndpointListener> tmpListeners = new HashSet<EndpointManager.EndpointListener>(this.endpointListeners);
            tmpListeners.remove(listener);
            this.endpointListeners = Collections.unmodifiableSet(tmpListeners);
        }

        @Override
        public void endpointCrashed(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                listener.endpointCrashed(endpoint);
            }
        }

        @Override
        public void endpointNoLongerInUse(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                listener.endpointNoLongerInUse(endpoint);
            }
        }

        @Override
        public void endpointNowInUse(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                if (listener instanceof PdxRegistryRecoveryListener) continue;
                listener.endpointNowInUse(endpoint);
            }
        }

        void clearPdxRegistry(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                if (!(listener instanceof PdxRegistryRecoveryListener)) continue;
                listener.endpointNowInUse(endpoint);
            }
        }
    }
}

