/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.pdx.internal.PdxType;
import org.jetbrains.annotations.NotNull;

public class GetPDXTypeByIdOp {
    public static PdxType execute(ExecutablePool pool, int pdxId) {
        GetPDXTypeByIdOpImpl op = new GetPDXTypeByIdOpImpl(pdxId);
        return (PdxType)pool.execute(op);
    }

    private GetPDXTypeByIdOp() {
    }

    private static class GetPDXTypeByIdOpImpl
    extends AbstractOp {
        public GetPDXTypeByIdOpImpl(int pdxId) {
            super(92, 1);
            this.getMessage().addIntPart(pdxId);
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            return this.processObjResponse(msg, "getPDXTypeById");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetPDXTypeById();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetPDXTypeByIdSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetPDXTypeById(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }
    }
}

