/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import it.unimi.dsi.fastutil.Hash;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.Bag;
import org.apache.geode.cache.query.internal.HashingStrategy;
import org.apache.geode.cache.query.internal.ObjectIntHashMap;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.cache.query.internal.StructFields;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.StructSet;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class StructBag
extends ResultsBag
implements StructFields {
    private boolean modifiable = true;

    public StructBag() {
    }

    public StructBag(StructType structType, CachePerfStats stats) {
        super(new ObjectArrayHashingStrategy(), stats);
        if (structType == null) {
            throw new IllegalArgumentException("structType must not be null");
        }
        this.elementType = structType;
    }

    public StructBag(Collection c, StructType structType, CachePerfStats stats) {
        super(c, (HashingStrategy)new ObjectArrayHashingStrategy(), stats);
        if (structType == null) {
            throw new IllegalArgumentException("structType must not be null");
        }
        this.elementType = structType;
    }

    public StructBag(int initialCapacity, StructType structType, CachePerfStats stats) {
        super(initialCapacity, (HashingStrategy)new ObjectArrayHashingStrategy(), stats);
        if (structType == null) {
            throw new IllegalArgumentException("structType must not be null");
        }
        this.elementType = structType;
    }

    public StructBag(int initialCapacity, float loadFactor, StructType structType, CachePerfStats stats) {
        super(initialCapacity, loadFactor, new ObjectArrayHashingStrategy(), stats);
        if (structType == null) {
            throw new IllegalArgumentException("structType must not be null");
        }
        this.elementType = structType;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean add(Object obj) {
        if (!(obj instanceof StructImpl)) {
            throw new IllegalArgumentException("This set only accepts StructImpl");
        }
        StructImpl s = (StructImpl)obj;
        if (!this.elementType.equals(s.getStructType())) {
            throw new IllegalArgumentException(String.format("obj does not have the same StructType.; collection structype,%s; added obj type=%s", this.elementType, s.getStructType()));
        }
        return this.addFieldValues(s.getFieldValues());
    }

    @Override
    public boolean addFieldValues(Object[] fieldValues) {
        return super.add(fieldValues);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        if (!this.elementType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.containsFieldValues(s.getFieldValues());
    }

    @Override
    public boolean containsFieldValues(Object[] fieldValues) {
        if (this.hasLimitIterator) {
            Iterator fieldItr = this.fieldValuesIterator();
            while (fieldItr.hasNext()) {
                if (!Arrays.equals((Object[])fieldItr.next(), fieldValues)) continue;
                return true;
            }
            return false;
        }
        return super.contains(fieldValues);
    }

    @Override
    public int occurrences(Object element) {
        if (!(element instanceof Struct)) {
            return 0;
        }
        Struct s = (Struct)element;
        if (!this.elementType.equals(StructTypeImpl.typeFromStruct(s))) {
            return 0;
        }
        if (this.hasLimitIterator) {
            int count = 0;
            boolean encounteredObject = false;
            Object[] fields = s.getFieldValues();
            Iterator itr = this.fieldValuesIterator();
            while (itr.hasNext()) {
                Object[] structFields = (Object[])itr.next();
                if (Arrays.equals(fields, structFields)) {
                    ++count;
                    encounteredObject = true;
                    continue;
                }
                if (!encounteredObject) continue;
                break;
            }
            return count;
        }
        return this.map.get(s.getFieldValues());
    }

    @Override
    public int occurrences(Object[] element) {
        return this.map.get(element);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)o;
        if (!this.elementType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.removeFieldValues(s.getFieldValues());
    }

    @Override
    public boolean removeFieldValues(Object[] fieldValues) {
        if (this.hasLimitIterator) {
            Iterator fieldItr = this.fieldValuesIterator();
            while (fieldItr.hasNext()) {
                if (!Arrays.equals((Object[])fieldItr.next(), fieldValues)) continue;
                fieldItr.remove();
                return true;
            }
            return false;
        }
        return super.remove(fieldValues);
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(StructBag.class, this.elementType);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c instanceof StructFields) {
            return this.addAll((StructFields)((Object)c));
        }
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c instanceof StructFields) {
            return this.removeAll((StructFields)((Object)c));
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        if (c instanceof StructFields) {
            return this.retainAll((StructFields)((Object)c));
        }
        return super.retainAll(c);
    }

    public boolean addAll(StructFields sb) {
        boolean modified = false;
        if (!this.elementType.equals(sb.getCollectionType().getElementType())) {
            throw new IllegalArgumentException("types do not match");
        }
        Iterator itr = sb.fieldValuesIterator();
        while (itr.hasNext()) {
            QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
            Object[] vals = (Object[])itr.next();
            if (!super.add(vals)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(StructFields ss) {
        boolean modified = false;
        if (!this.elementType.equals(ss.getCollectionType().getElementType())) {
            return false;
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            Object[] vals = (Object[])itr.next();
            if (!this.removeFieldValues(vals)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(StructFields ss) {
        if (!this.elementType.equals(ss.getCollectionType().getElementType())) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean changed = false;
        int size = this.size();
        Iterator it = this.fieldValuesIterator();
        while (size-- > 0) {
            Object[] vals = (Object[])it.next();
            if (ss.containsFieldValues(vals)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Iterator iterator() {
        return new StructBagIterator(this.fieldValuesIterator());
    }

    @Override
    public Iterator fieldValuesIterator() {
        return super.iterator();
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (!(elementType instanceof StructTypeImpl)) {
            throw new IllegalArgumentException("element type must be struct");
        }
        this.elementType = elementType;
    }

    @Override
    public Set asSet() {
        return new StructSet(this);
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public int getDSFID() {
        return 16;
    }

    @Override
    protected ObjectIntHashMap createMapForFromData() {
        return new ObjectIntHashMap(this.size, new ObjectArrayHashingStrategy());
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.modifiable = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeBoolean(this.modifiable);
    }

    @Override
    void writeNumNulls(DataOutput out) {
    }

    @Override
    void readNumNulls(DataInput in) {
    }

    void createTObjectIntHashMap() {
        this.map = new ObjectIntHashMap(this.size, new ObjectArrayHashingStrategy());
    }

    private class StructBagIterator
    extends Bag.BagIterator {
        private final Iterator itr;

        StructBagIterator(Iterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Object next() {
            return new StructImpl((StructTypeImpl)StructBag.this.elementType, (Object[])this.itr.next());
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    protected static class ObjectArrayFUHashingStrategy
    implements Hash.Strategy<Object> {
        private static final long serialVersionUID = 8975047264555337042L;

        protected ObjectArrayFUHashingStrategy() {
        }

        public int hashCode(Object o) {
            if (!(o instanceof Object[])) {
                throw new ClassCastException(String.format("Expected an Object[], but actual is %s", o.getClass().getName()));
            }
            Object[] oa = (Object[])o;
            int h = 0;
            for (Object obj : oa) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (!(o1 instanceof Object[]) || !(o2 instanceof Object[])) {
                return o1.equals(o2);
            }
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
    }

    protected static class ObjectArrayHashingStrategy
    implements HashingStrategy {
        protected ObjectArrayHashingStrategy() {
        }

        @Override
        public int hashCode(Object o) {
            Object[] oa = (Object[])o;
            return Arrays.deepHashCode(oa);
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (!(o1 instanceof Object[]) || !(o2 instanceof Object[])) {
                return o1.equals(o2);
            }
            return Arrays.deepEquals((Object[])o1, (Object[])o2);
        }
    }
}

