/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;

public class PooledExecutorWithDMStats
extends ThreadPoolExecutor {
    private final PoolStatHelper poolStatHelper;
    private final ThreadsMonitoring threadsMonitoring;
    private BlockingQueue<Runnable> blockingWorkQueue;
    private Thread bufferConsumer;

    public PooledExecutorWithDMStats(int poolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        this(poolSize, keepAliveTime, unit, PooledExecutorWithDMStats.getSynchronousQueue(workQueue), threadFactory, PooledExecutorWithDMStats.newRejectedExecutionHandler(workQueue), poolStatHelper, threadsMonitoring);
        if (!(workQueue instanceof SynchronousQueue)) {
            this.blockingWorkQueue = workQueue;
            BlockingQueue<Runnable> takeQueue = workQueue;
            BlockingQueue<Runnable> putQueue = this.getQueue();
            Runnable r = () -> {
                try {
                    while (true) {
                        SystemFailure.checkFailure();
                        Runnable job = (Runnable)takeQueue.take();
                        putQueue.put(job);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            };
            this.bufferConsumer = threadFactory.newThread(r);
            this.bufferConsumer.start();
        }
    }

    public PooledExecutorWithDMStats(int poolSize, long keepAliveTime, TimeUnit unit, SynchronousQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        super(PooledExecutorWithDMStats.getCorePoolSize(poolSize), poolSize, keepAliveTime, unit, workQueue, threadFactory, rejectedExecutionHandler);
        this.poolStatHelper = poolStatHelper;
        this.threadsMonitoring = threadsMonitoring;
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.terminated();
        }
    }

    @Override
    protected void terminated() {
        if (this.bufferConsumer != null) {
            this.bufferConsumer.interrupt();
        }
        super.terminated();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.terminated();
        List<Runnable> l = super.shutdownNow();
        if (this.blockingWorkQueue != null) {
            this.blockingWorkQueue.drainTo(l);
        }
        return l;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.poolStatHelper != null) {
            this.poolStatHelper.startJob();
        }
        if (this.threadsMonitoring != null) {
            this.threadsMonitoring.startMonitor(ThreadsMonitoring.Mode.PooledExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable ex) {
        if (this.poolStatHelper != null) {
            this.poolStatHelper.endJob();
        }
        if (this.threadsMonitoring != null) {
            this.threadsMonitoring.endMonitor();
        }
    }

    private static int getCorePoolSize(int maxSize) {
        if (maxSize == Integer.MAX_VALUE) {
            return 0;
        }
        return 1;
    }

    private static SynchronousQueue<Runnable> getSynchronousQueue(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue) {
            return (SynchronousQueue)q;
        }
        return new SynchronousQueue<Runnable>();
    }

    private static RejectedExecutionHandler newRejectedExecutionHandler(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        return new BufferHandler();
    }

    public static class BufferHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                PooledExecutorWithDMStats pool = (PooledExecutorWithDMStats)executor;
                pool.blockingWorkQueue.put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ie);
            }
        }
    }

    public static class BlockHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ie);
            }
        }
    }
}

