/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DeposeGrantorProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();

    static void send(String serviceName, InternalDistributedMember oldGrantor, InternalDistributedMember newGrantor, long newGrantorVersion, int newGrantorSerialNumber, DistributionManager dm) {
        InternalDistributedMember elder = dm.getId();
        if (elder.equals(oldGrantor)) {
            DeposeGrantorProcessor.doOldGrantorWork(serviceName, elder, newGrantor, newGrantorVersion, newGrantorSerialNumber, dm, null);
        } else {
            DeposeGrantorProcessor processor = new DeposeGrantorProcessor(dm, oldGrantor);
            DeposeGrantorMessage.send(serviceName, oldGrantor, newGrantor, newGrantorVersion, newGrantorSerialNumber, dm, processor);
            try {
                processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleCause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doOldGrantorWork(String serviceName, InternalDistributedMember elder, InternalDistributedMember youngTurk, long newGrantorVersion, int newGrantorSerialNumber, DistributionManager dm, DeposeGrantorMessage msg) {
        try {
            DLockService svc = DLockService.getInternalServiceNamed(serviceName);
            if (svc != null) {
                LockGrantorId newLockGrantorId = new LockGrantorId(dm, youngTurk, newGrantorVersion, newGrantorSerialNumber);
                svc.deposeOlderLockGrantorId(newLockGrantorId);
            }
        }
        finally {
            if (msg != null) {
                msg.reply(dm);
            }
        }
    }

    private DeposeGrantorProcessor(DistributionManager dm, InternalDistributedMember oldGrantor) {
        super(dm, oldGrantor);
    }

    public static class DeposeGrantorMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private String serviceName;
        private InternalDistributedMember newGrantor;
        private long newGrantorVersion;
        private int newGrantorSerialNumber;

        protected static void send(String serviceName, InternalDistributedMember oldGrantor, InternalDistributedMember newGrantor, long newGrantorVersion, int newGrantorSerialNumber, DistributionManager dm, ReplyProcessor21 proc) {
            DeposeGrantorMessage msg = new DeposeGrantorMessage();
            msg.serviceName = serviceName;
            msg.newGrantor = newGrantor;
            msg.newGrantorVersion = newGrantorVersion;
            msg.newGrantorSerialNumber = newGrantorSerialNumber;
            msg.processorId = proc.getProcessorId();
            msg.setRecipient(oldGrantor);
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "DeposeGrantorMessage sending {} to {}", (Object)msg, (Object)oldGrantor);
            }
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        void reply(DistributionManager dm) {
            ReplyMessage.send(this.getSender(), this.getProcessorId(), null, (ReplySender)dm);
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            InternalDistributedMember elder = this.getSender();
            InternalDistributedMember youngTurk = this.newGrantor;
            DeposeGrantorProcessor.doOldGrantorWork(this.serviceName, elder, youngTurk, this.newGrantorVersion, this.newGrantorSerialNumber, dm, this);
        }

        public int getDSFID() {
            return 114;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            this.serviceName = DataSerializer.readString(in);
            this.newGrantor = (InternalDistributedMember)DataSerializer.readObject(in);
            this.newGrantorVersion = in.readLong();
            this.newGrantorSerialNumber = in.readInt();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            DataSerializer.writeString(this.serviceName, out);
            DataSerializer.writeObject(this.newGrantor, out);
            out.writeLong(this.newGrantorVersion);
            out.writeInt(this.newGrantorSerialNumber);
        }

        @Override
        public String toString() {
            return "DeposeGrantorMessage (serviceName='" + this.serviceName + "' processorId=" + this.processorId + " newGrantor=" + this.newGrantor + " newGrantorVersion=" + this.newGrantorVersion + " newGrantorSerialNumber=" + this.newGrantorSerialNumber + ")";
        }
    }
}

