/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import org.apache.commons.lang3.JavaVersion;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.geode.unsafe.internal.sun.misc.Unsafe;

public class JvmSizeUtils {
    private static final boolean is64Bit;
    private static final int referenceSize;
    private static final int objectHeaderSize;
    @Immutable
    private static final Unsafe unsafe;

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static int getReferenceSize() {
        return referenceSize;
    }

    public static int getObjectHeaderSize() {
        return objectHeaderSize;
    }

    public static long roundUpSize(long size) {
        return size + 7L & 0xFFFFFFFFFFFFFFF8L;
    }

    public static int roundUpSize(int size) {
        return (int)JvmSizeUtils.roundUpSize((long)size);
    }

    public static int memoryOverhead(byte[] byteArray) {
        if (byteArray == null) {
            return 0;
        }
        int result = JvmSizeUtils.getObjectHeaderSize();
        result += 4;
        return JvmSizeUtils.roundUpSize(result += byteArray.length);
    }

    public static int memoryOverhead(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int result = JvmSizeUtils.getObjectHeaderSize();
        result += 4;
        return JvmSizeUtils.roundUpSize(result += objectArray.length * JvmSizeUtils.getReferenceSize());
    }

    public static int memoryOverhead(Class<?> clazz) {
        return (int)ReflectionSingleObjectSizer.sizeof(clazz);
    }

    static {
        int ibmbits;
        Unsafe tmp = null;
        try {
            tmp = new Unsafe();
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Error error) {
            // empty catch block
        }
        unsafe = tmp;
        int sunbits = Integer.getInteger("sun.arch.data.model", 0);
        is64Bit = sunbits == 64 ? true : (sunbits == 32 ? false : ((ibmbits = Integer.getInteger("com.ibm.vm.bitmode", 0).intValue()) == 64 ? true : (ibmbits == 32 ? false : (unsafe != null ? unsafe.getAddressSize() == 8 : false))));
        if (!is64Bit) {
            referenceSize = 4;
            objectHeaderSize = 8;
        } else {
            int scaleIndex = 0;
            int tmpReferenceSize = 0;
            int tmpObjectHeaderSize = 0;
            if (SystemUtils.isAzulJVM()) {
                tmpObjectHeaderSize = 8;
                tmpReferenceSize = 8;
            } else {
                if (unsafe != null) {
                    scaleIndex = unsafe.arrayScaleIndex(Object[].class);
                    if (scaleIndex == 4) {
                        tmpReferenceSize = 4;
                        tmpObjectHeaderSize = 12;
                    } else if (scaleIndex == 8) {
                        tmpReferenceSize = 8;
                        tmpObjectHeaderSize = 16;
                    } else {
                        System.out.println("Unexpected arrayScaleIndex " + scaleIndex + ". Using max heap size to estimate reference size.");
                        scaleIndex = 0;
                    }
                }
                if (scaleIndex == 0) {
                    long SMALL_OOP_BOUNDARY = 32L;
                    if (org.apache.commons.lang3.SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
                        SMALL_OOP_BOUNDARY = 64L;
                    }
                    if (Runtime.getRuntime().maxMemory() > SMALL_OOP_BOUNDARY * 1024L * 1024L * 1024L) {
                        tmpReferenceSize = 8;
                        tmpObjectHeaderSize = 16;
                    } else {
                        tmpReferenceSize = 4;
                        tmpObjectHeaderSize = 12;
                    }
                }
            }
            referenceSize = tmpReferenceSize;
            objectHeaderSize = tmpObjectHeaderSize;
        }
    }
}

