/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.util.Set;
import org.apache.geode.admin.OperationCancelledException;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CancellationMessage;

public class AdminWaiters {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminResponse sendAndWait(AdminRequest msg, ClusterDistributionManager dm) {
        if (dm.getId().equals(msg.getRecipient())) {
            msg.setSender(dm.getId());
            return msg.createResponse(dm);
        }
        AdminResponse result = null;
        try {
            AdminRequest adminRequest = msg;
            synchronized (adminRequest) {
                Set<InternalDistributedMember> failures = dm.putOutgoing(msg);
                if (failures != null && failures.size() > 0) {
                    if (dm.getDistributionManagerIds().contains(msg.getRecipient())) {
                        String s = " (" + msg + ")";
                        throw new RuntimeAdminException(String.format("Could not send request.%s", s));
                    }
                    throw new OperationCancelledException(String.format("Request sent to %s failed since member departed.%s", msg.getRecipient(), ""));
                }
                long timeout = AdminWaiters.getWaitTimeout();
                boolean gotResponse = msg.waitForResponse(timeout);
                if (!gotResponse) {
                    if (dm.isCurrentMember(msg.getRecipient())) {
                        String sb = "Administration request " + msg + " sent to " + msg.getRecipient() + " timed out after " + timeout / 1000L + " seconds.";
                        throw new RuntimeAdminException(sb);
                    }
                    String s = " (" + msg + ")";
                    throw new OperationCancelledException(String.format("Request sent to %s failed since member departed.%s", msg.getRecipient(), s));
                }
                result = msg.getResponse();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            dm.getCancelCriterion().checkCancelInProgress(ex);
            String s = "Request wait was interrupted.";
            s = s + " (" + msg + ")";
            throw new RuntimeAdminException(s, ex);
        }
        if (result == null) {
            String s = " (" + msg + ")";
            throw new OperationCancelledException(String.format("Request sent to %s was cancelled. %s", msg.getRecipient(), s));
        }
        if (result instanceof AdminFailureResponse) {
            throw new RuntimeAdminException("Request failed.", ((AdminFailureResponse)result).getCause());
        }
        return result;
    }

    public static void sendResponse(AdminResponse msg) {
        int id = msg.getMsgId();
        ReplyProcessor21 processor = ReplyProcessor21.getProcessor(id);
        if (processor == null) {
            return;
        }
        processor.process(msg);
    }

    public static void cancelWaiters(InternalDistributedMember id) {
    }

    public static void cancelRequest(int msgId, ClusterDistributionManager dm) {
        AdminReplyProcessor processor = (AdminReplyProcessor)ReplyProcessor21.getProcessor(msgId);
        if (processor != null) {
            InternalDistributedMember recipient = processor.getResponder();
            dm.putOutgoing(CancellationMessage.create(recipient, msgId));
            processor.cancel();
        }
    }

    private static long getWaitTimeout() {
        String prop = System.getProperty("remote.call.timeout", "1800");
        try {
            int val = Integer.parseInt(prop);
            return Math.abs((long)val * 1000L);
        }
        catch (NumberFormatException nfe) {
            return 1800000L;
        }
    }
}

