/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.IndexTrackingQueryObserver;
import org.apache.geode.cache.query.internal.PRQueryTraceInfo;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.streaming.StreamingOperation;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PRQueryProcessor;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.partitioned.StreamingPartitionOperation;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class QueryMessage
extends StreamingPartitionOperation.StreamingPartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile String queryString;
    private volatile boolean cqQuery;
    private volatile Object[] parameters;
    private volatile List buckets;
    private volatile boolean isPdxSerialized;
    private volatile boolean traceOn;
    private final List<Collection> resultCollector = new ArrayList<Collection>();
    private Iterator currentResultIterator;
    private Iterator<Collection> currentSelectResultIterator;
    private boolean isTraceInfoIteration = false;
    private boolean isStructType = false;

    public QueryMessage() {
    }

    public QueryMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, DefaultQuery query, Object[] parameters, List buckets) {
        super(recipient, regionId, processor);
        this.queryString = query.getQueryString();
        this.buckets = buckets;
        this.parameters = parameters;
        this.cqQuery = query.isCqQuery();
        this.traceOn = query.isTraced() || DefaultQuery.QUERY_VERBOSE;
    }

    @Override
    protected Object getNextReplyObject(PartitionedRegion pr) throws CacheException, ForceReattemptException, InterruptedException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (QueryMonitor.isLowMemory()) {
            String reason = String.format("Query execution canceled due to memory threshold crossed in system, memory used: %s bytes.", QueryMonitor.getMemoryUsedBytes());
            throw new QueryExecutionLowMemoryException(reason);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        while (this.currentResultIterator == null || !this.currentResultIterator.hasNext()) {
            if (this.currentSelectResultIterator.hasNext()) {
                if (this.isTraceInfoIteration && this.currentResultIterator != null) {
                    this.isTraceInfoIteration = false;
                }
                Collection results = this.currentSelectResultIterator.next();
                if (isDebugEnabled) {
                    logger.debug("Query result size: {}", (Object)results.size());
                }
                this.currentResultIterator = results.iterator();
                continue;
            }
            return Token.END_OF_STREAM;
        }
        Object data = this.currentResultIterator.next();
        boolean isPostGFE_8_1 = this.getSender().getVersion().isNewerThan((Version)KnownVersion.GFE_81);
        if (this.isStructType && !this.isTraceInfoIteration && isPostGFE_8_1) {
            return ((Struct)data).getFieldValues();
        }
        if (this.isStructType && !this.isTraceInfoIteration) {
            Struct struct = (Struct)data;
            ObjectType[] fieldTypes = struct.getStructType().getFieldTypes();
            for (int i = 0; i < fieldTypes.length; ++i) {
                fieldTypes[i] = new ObjectTypeImpl(Object.class);
            }
            return data;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        long traceStartTime = 0L;
        if (this.traceOn) {
            traceStartTime = NanoTimer.getTime();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "QueryMessage operateOnPartitionedRegion: {} buckets {}", (Object)pr.getFullPath(), (Object)this.buckets);
        }
        pr.waitOnInitialization();
        if (QueryMonitor.isLowMemory()) {
            String reason = String.format("Query execution canceled due to memory threshold crossed in system, memory used: %s bytes.", QueryMonitor.getMemoryUsedBytes());
            throw new QueryExecutionLowMemoryException(reason);
        }
        DefaultQuery query = new DefaultQuery(this.queryString, pr.getCache(), false);
        QueryExecutionContext executionContext = new QueryExecutionContext(null, pr.getCache(), query);
        Boolean initialPdxReadSerialized = pr.getCache().getPdxReadSerializedOverride();
        pr.getCache().setPdxReadSerializedOverride(true);
        query.setRemoteQuery(true);
        QueryObserver indexObserver = query.startTrace();
        boolean isQueryTraced = false;
        List<PRQueryTraceInfo> queryTraceList = null;
        try {
            query.setIsCqQuery(this.cqQuery);
            PRQueryProcessor qp = new PRQueryProcessor(pr, query, this.parameters, this.buckets);
            if (logger.isDebugEnabled()) {
                logger.debug("Started executing query from remote node: {}", (Object)query.getQueryString());
            }
            isQueryTraced = query.isTraced() && this.sender.getVersion().isNotOlderThan((Version)KnownVersion.GFE_81);
            PRQueryTraceInfo queryTraceInfo = null;
            if (isQueryTraced) {
                this.isTraceInfoIteration = true;
                if (DefaultQuery.testHook != null) {
                    DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.CREATE_PR_QUERY_TRACE_INFO_FOR_REMOTE_QUERY, null, null);
                }
                queryTraceInfo = new PRQueryTraceInfo();
                queryTraceList = Collections.singletonList(queryTraceInfo);
            }
            this.isStructType = qp.executeQuery(this.resultCollector);
            if (isQueryTraced) {
                this.resultCollector.add(0, queryTraceList);
            }
            this.currentSelectResultIterator = this.resultCollector.iterator();
            if (isQueryTraced) {
                if (DefaultQuery.testHook != null) {
                    DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.POPULATING_TRACE_INFO_FOR_REMOTE_QUERY, null, null);
                }
                int traceSize = queryTraceInfo.calculateNumberOfResults(this.resultCollector);
                queryTraceInfo.setTimeInMillis((float)(NanoTimer.getTime() - traceStartTime) / 1000000.0f);
                queryTraceInfo.setNumResults(--traceSize);
                if (indexObserver instanceof IndexTrackingQueryObserver) {
                    Map indexesUsed = ((IndexTrackingQueryObserver)indexObserver).getUsedIndexes();
                    StringBuilder sb = new StringBuilder();
                    sb.append(" indexesUsed(").append(indexesUsed.size()).append(")");
                    if (indexesUsed.size() > 0) {
                        sb.append(":");
                        Iterator itr = indexesUsed.entrySet().iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            sb.append(entry.getKey()).append(entry.getValue());
                            if (!itr.hasNext()) continue;
                            sb.append(",");
                        }
                    }
                    queryTraceInfo.setIndexesUsed(sb.toString());
                }
            }
            if (QueryMonitor.isLowMemory()) {
                String reason = String.format("Query execution canceled due to memory threshold crossed in system, memory used: %s bytes.", QueryMonitor.getMemoryUsedBytes());
                throw new QueryExecutionLowMemoryException(reason);
            }
            if (executionContext.isCanceled()) {
                throw executionContext.getQueryCanceledException();
            }
            super.operateOnPartitionedRegion(dm, pr, startTime);
        }
        finally {
            if (isQueryTraced) {
                this.resultCollector.remove(queryTraceList);
            }
            pr.getCache().setPdxReadSerializedOverride(initialPdxReadSerialized);
            query.setRemoteQuery(false);
            query.endTrace(indexObserver, traceStartTime, this.resultCollector);
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; query=").append(this.queryString).append("; bucketids=").append(this.buckets);
    }

    public int getDSFID() {
        return 58;
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, PartitionedRegion pr, long startTime) {
        if (ex != null) {
            this.outStream = null;
            this.replyMsgNum = 0;
            this.replyLastMsg = true;
        }
        if (this.replyLastMsg && pr != null && startTime > 0L) {
            pr.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        StreamingOperation.StreamingReplyMessage.send(member, procId, ex, dm, this.outStream, this.numObjectsInChunk, this.replyMsgNum, this.replyLastMsg, this.isPdxSerialized);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.queryString = DataSerializer.readString(in);
        this.buckets = DataSerializer.readArrayList(in);
        this.parameters = DataSerializer.readObjectArray(in);
        this.cqQuery = DataSerializer.readBoolean(in);
        this.isPdxSerialized = DataSerializer.readBoolean(in);
        this.traceOn = DataSerializer.readBoolean(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.queryString, out);
        DataSerializer.writeArrayList((ArrayList)this.buckets, out);
        DataSerializer.writeObjectArray(this.parameters, out);
        DataSerializer.writeBoolean(this.cqQuery, out);
        DataSerializer.writeBoolean(true, out);
        DataSerializer.writeBoolean(this.traceOn, out);
    }
}

