/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionService;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionServiceImpl;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.InternalFunctionService;
import org.apache.geode.internal.cache.execute.MemberFunctionExecutor;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender65;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.jetbrains.annotations.NotNull;

public class ExecuteFunction70
extends BaseCommand {
    @Immutable
    private static final ExecuteFunction70 singleton = new ExecuteFunction70();
    @MakeNotStatic
    private static volatile boolean asyncTxWarningIssued;
    @Immutable
    private static final ExecutorService execService;
    private final InternalFunctionExecutionService internalFunctionExecutionService;
    private final ServerToClientFunctionResultSender65Factory serverToClientFunctionResultSender65Factory;
    private final FunctionContextImplFactory functionContextImplFactory;

    ExecuteFunction70() {
        this(InternalFunctionService.getInternalFunctionExecutionService(), new DefaultServerToClientFunctionResultSender65Factory(), new DefaultFunctionContextImplFactory());
    }

    ExecuteFunction70(InternalFunctionExecutionService internalFunctionExecutionService, ServerToClientFunctionResultSender65Factory serverToClientFunctionResultSender65Factory, FunctionContextImplFactory functionContextImplFactory) {
        this.internalFunctionExecutionService = internalFunctionExecutionService;
        this.serverToClientFunctionResultSender65Factory = serverToClientFunctionResultSender65Factory;
        this.functionContextImplFactory = functionContextImplFactory;
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException {
        String message;
        boolean ignoreFailedMembers;
        boolean allMembers;
        String[] groups;
        Object args;
        byte functionState;
        Object function = null;
        MemberMappedArgument memberMappedArg = null;
        byte hasResult = 0;
        boolean isReexecute = false;
        int functionTimeout = 0;
        try {
            byte[] bytes = clientMessage.getPart(0).getSerializedForm();
            functionState = bytes[0];
            if (bytes.length >= 5) {
                functionTimeout = Part.decodeInt(bytes, 1);
            }
            if (functionState == 11) {
                functionState = 3;
                isReexecute = true;
            } else if (functionState == 15) {
                functionState = 7;
                isReexecute = true;
            }
            hasResult = functionState != 1 ? (byte)((byte)((functionState & 2) - 1)) : functionState;
            if (hasResult == 1) {
                serverConnection.setAsTrue(2);
                serverConnection.setAsTrue(3);
            }
            function = clientMessage.getPart(1).getStringOrObject();
            args = clientMessage.getPart(2).getObject();
            Part part = clientMessage.getPart(3);
            if (part != null) {
                memberMappedArg = (MemberMappedArgument)part.getObject();
            }
            groups = this.getGroups(clientMessage);
            allMembers = this.getAllMembers(clientMessage);
            ignoreFailedMembers = this.getIgnoreFailedMembers(clientMessage);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Exception on server while executing function: {}", function, (Object)e);
            if (hasResult == 1) {
                ExecuteFunction70.writeChunkedException(clientMessage, e, serverConnection);
            } else {
                ExecuteFunction70.writeException(clientMessage, e, false, serverConnection);
            }
            serverConnection.setAsTrue(1);
            return;
        }
        if (function == null) {
            String message2 = "The input function for the execute function request is null";
            logger.warn("{} : {}", (Object)serverConnection.getName(), (Object)message2);
            this.sendError(hasResult, clientMessage, message2, serverConnection);
            return;
        }
        try {
            Function functionObject;
            if (function instanceof String) {
                functionObject = this.internalFunctionExecutionService.getFunction((String)function);
                if (functionObject == null) {
                    message = String.format("Function named %s is not registered to FunctionService", function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
                byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                if (logger.isDebugEnabled()) {
                    logger.debug("Function State on server side: {} on client: {}", (Object)functionStateOnServerSide, (Object)functionState);
                }
                if (functionStateOnServerSide != functionState) {
                    String message3 = String.format("Function attributes at client and server don't match for %s", function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message3);
                    this.sendError(hasResult, clientMessage, message3, serverConnection);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStatsManager.getFunctionStats(functionObject.getId());
            functionObject.getRequiredPermissions(null, args).forEach(securityService::authorize);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage chunkedMessage = serverConnection.getFunctionResponseMessage();
            chunkedMessage.setTransactionId(clientMessage.getTransactionId());
            ServerToClientFunctionResultSender65 resultSender = this.serverToClientFunctionResultSender65Factory.create(chunkedMessage, 63, serverConnection, functionObject, executeContext);
            InternalCache cache = serverConnection.getCache();
            InternalDistributedMember localVM = (InternalDistributedMember)cache.getDistributedSystem().getDistributedMember();
            FunctionContextImpl context = memberMappedArg != null ? this.functionContextImplFactory.create(cache, functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender, isReexecute) : this.functionContextImplFactory.create(cache, functionObject.getId(), args, resultSender, isReexecute);
            ServerSideHandshake handshake = serverConnection.getHandshake();
            int earlierClientReadTimeout = handshake.getClientReadTimeout();
            handshake.setClientReadTimeout(functionTimeout);
            try {
                LowMemoryException lowMemoryException;
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: {} with context: {}", (Object)serverConnection, (Object)context);
                }
                if ((lowMemoryException = cache.getInternalResourceManager().getHeapMonitor().createLowMemoryIfNeeded(functionObject, cache.getMyId())) != null) {
                    this.sendException(hasResult, clientMessage, lowMemoryException.getMessage(), serverConnection, lowMemoryException);
                    return;
                }
                DistributionManager dm = cache.getDistributionManager();
                if (groups != null && groups.length > 0) {
                    this.executeFunctionOnGroups(function, args, groups, allMembers, functionObject, resultSender, ignoreFailedMembers);
                } else {
                    this.executeFunctionLocally(functionObject, context, resultSender, dm, stats);
                }
                if (!functionObject.hasResult()) {
                    this.writeReply(clientMessage, serverConnection);
                }
            }
            catch (FunctionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FunctionException(e);
            }
            finally {
                handshake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException e) {
            logger.warn("Exception on server while executing function: {}}", function, (Object)e);
            message = "Server could not send the reply";
            this.sendException(hasResult, clientMessage, message, serverConnection, e);
        }
        catch (InternalFunctionInvocationTargetException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception on server while executing function: {}", function, (Object)e);
            }
            this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
        }
        catch (Exception e) {
            logger.warn("Exception on server while executing function: {}", function, (Object)e);
            this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
        }
    }

    protected boolean getIgnoreFailedMembers(Message msg) {
        return this.isFlagSet(msg, 1);
    }

    protected boolean getAllMembers(Message msg) {
        return this.isFlagSet(msg, 0);
    }

    private boolean isFlagSet(Message msg, int index) {
        byte[] flags;
        boolean isSet = false;
        Part messagePart = msg.getPart(5);
        if (messagePart != null && (flags = messagePart.getSerializedForm()) != null && flags.length > index && flags[index] == 1) {
            isSet = true;
        }
        return isSet;
    }

    protected void executeFunctionOnGroups(Object function, Object args, String[] groups, boolean allMembers, Function functionObject, ServerToClientFunctionResultSender resultSender, boolean ignoreFailedMembers) {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds == null) {
            throw new IllegalStateException("DistributedSystem is either not created or not ready");
        }
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        for (String group : groups) {
            if (allMembers) {
                members.addAll(((DistributedSystem)ds).getGroupMembers(group));
                continue;
            }
            ArrayList<DistributedMember> memberList = new ArrayList<DistributedMember>(((DistributedSystem)ds).getGroupMembers(group));
            if (memberList.isEmpty()) continue;
            if (!InternalFunctionExecutionServiceImpl.RANDOM_onMember && memberList.contains(((DistributedSystem)ds).getDistributedMember())) {
                members.add(((DistributedSystem)ds).getDistributedMember());
                continue;
            }
            Collections.shuffle(memberList);
            members.add((DistributedMember)memberList.get(0));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing Function on Groups: {} all members: {} members are: {}", (Object)Arrays.toString(groups), (Object)allMembers, members);
        }
        Execution execution = new MemberFunctionExecutor(ds, members, resultSender);
        if (args != null) {
            execution = execution.setArguments(args);
        }
        if (ignoreFailedMembers) {
            if (logger.isDebugEnabled()) {
                logger.debug("Function will ignore failed members");
            }
            ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        }
        if (!functionObject.isHA()) {
            ((AbstractExecution)execution).setWaitOnExceptionFlag(true);
        }
        if (function instanceof String) {
            execution.execute(functionObject.getId()).getResult();
        } else {
            execution.execute(functionObject).getResult();
        }
    }

    public static Command getCommand() {
        return singleton;
    }

    protected String[] getGroups(Message msg) throws IOException, ClassNotFoundException {
        String[] groups = null;
        Part messagePart = msg.getPart(4);
        if (messagePart != null) {
            groups = (String[])messagePart.getObject();
        }
        return groups;
    }

    private void executeFunctionLocally(Function fn, FunctionContext cx, ServerToClientFunctionResultSender65 sender, DistributionManager dm, FunctionStats stats) throws IOException {
        if (fn.hasResult()) {
            long startExecution = stats.startFunctionExecution(fn.hasResult());
            try {
                fn.execute(cx);
                if (sender.isOkayToSendResult() && !sender.isLastResultReceived() && fn.hasResult()) {
                    throw new FunctionException(String.format("The function, %s, did not send last result", fn.getId()));
                }
                stats.endFunctionExecution(startExecution, fn.hasResult());
            }
            catch (Exception e) {
                stats.endFunctionExecutionWithException(startExecution, fn.hasResult());
                throw e;
            }
        } else {
            TXStateProxy txState = TXManagerImpl.getCurrentTXState();
            Runnable functionExecution = () -> {
                GemFireCacheImpl cache = null;
                long startExecution = stats.startFunctionExecution(fn.hasResult());
                try {
                    if (txState != null) {
                        cache = GemFireCacheImpl.getExisting("executing function");
                        cache.getTxManager().masqueradeAs(txState);
                        if (cache.getLogger().warningEnabled() && !asyncTxWarningIssued) {
                            asyncTxWarningIssued = true;
                            cache.getLogger().warning("Function invoked within transactional context, but hasResults() is false; ordering of transactional operations cannot be guaranteed.  This message is only issued once by a server.");
                        }
                    }
                    fn.execute(cx);
                    stats.endFunctionExecution(startExecution, fn.hasResult());
                }
                catch (InternalFunctionInvocationTargetException e) {
                    stats.endFunctionExecutionWithException(startExecution, fn.hasResult());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Exception on server while executing function: {}", (Object)fn, (Object)e);
                    }
                }
                catch (Exception e) {
                    stats.endFunctionExecutionWithException(startExecution, fn.hasResult());
                    logger.warn("Exception on server while executing function: {}", (Object)fn, (Object)e);
                }
                finally {
                    if (txState != null && cache != null) {
                        cache.getTxManager().unmasquerade(txState);
                    }
                }
            };
            if (dm == null) {
                execService.execute(functionExecution);
            } else {
                ClusterDistributionManager newDM = (ClusterDistributionManager)dm;
                newDM.getExecutors().getFunctionExecutor().execute(functionExecution);
            }
        }
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction70.writeFunctionResponseException(msg, 2, serverConnection, e);
        } else {
            ExecuteFunction70.writeException(msg, e, false, serverConnection);
        }
        serverConnection.setAsTrue(1);
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction70.writeFunctionResponseError(msg, 64, message, serverConnection);
        } else {
            ExecuteFunction70.writeErrorResponse(msg, 64, message, serverConnection);
        }
        serverConnection.setAsTrue(1);
    }

    static {
        execService = LoggingExecutors.newCachedThreadPool((String)"Function Execution Thread-", (boolean)true);
    }

    private static class DefaultFunctionContextImplFactory
    implements FunctionContextImplFactory {
        private DefaultFunctionContextImplFactory() {
        }

        @Override
        public FunctionContextImpl create(Cache cache, String functionId, Object args, ResultSender resultSender, boolean isPossibleDuplicat) {
            return new FunctionContextImpl(cache, functionId, args, resultSender, isPossibleDuplicat);
        }
    }

    private static class DefaultServerToClientFunctionResultSender65Factory
    implements ServerToClientFunctionResultSender65Factory {
        private DefaultServerToClientFunctionResultSender65Factory() {
        }

        @Override
        public ServerToClientFunctionResultSender65 create(ChunkedMessage msg, int messageType, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
            return new ServerToClientFunctionResultSender65(msg, messageType, sc, function, authzContext);
        }
    }

    static interface FunctionContextImplFactory {
        public FunctionContextImpl create(Cache var1, String var2, Object var3, ResultSender var4, boolean var5);
    }

    static interface ServerToClientFunctionResultSender65Factory {
        public ServerToClientFunctionResultSender65 create(ChunkedMessage var1, int var2, ServerConnection var3, Function var4, ExecuteFunctionOperationContext var5);
    }
}

