/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.InvalidateOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class Invalidate70
extends BaseCommand {
    @Immutable
    private static final Invalidate70 singleton = new Invalidate70();

    public static Command getCommand() {
        return singleton;
    }

    private Invalidate70() {
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        Part eventPart = null;
        StringBuilder errMessage = new StringBuilder();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadInvalidateRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        keyPart = clientMessage.getPart(1);
        eventPart = clientMessage.getPart(2);
        if (clientMessage.getNumberOfParts() > 3) {
            callbackArgPart = clientMessage.getPart(3);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Invalidate70.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getCachedString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Invalidate70.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(serverConnection.getName() + ": Received invalidate request (" + clientMessage.getPayloadLength() + " bytes) from " + serverConnection.getSocketString() + " for region " + regionName + " key " + key);
        }
        if (key == null || regionName == null) {
            if (key == null) {
                logger.warn("The input key for the invalidate request is null");
                errMessage.append("The input key for the invalidate request is null");
            }
            if (regionName == null) {
                logger.warn("The input region name for the invalidate request is null");
                errMessage.append("The input region name for the invalidate request is null");
            }
            Invalidate70.writeErrorResponse(clientMessage, 10, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = " was not found during invalidate request";
            Invalidate70.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        Breadcrumbs.setEventId(eventId);
        VersionTag tag = null;
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                InvalidateOperationContext invalidateContext = authzRequest.invalidateAuthorize(regionName, key, callbackArg);
                callbackArg = invalidateContext.getCallbackArg();
            }
            EventIDHolder clientEvent = new EventIDHolder(eventId);
            if (clientMessage.isRetry()) {
                clientEvent.setPossibleDuplicate(true);
                if (region.getAttributes().getConcurrencyChecksEnabled()) {
                    clientEvent.setRegion(region);
                    if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                        clientEvent.setPossibleDuplicate(false);
                    }
                }
            }
            region.basicBridgeInvalidate(key, callbackArg, serverConnection.getProxyID(), true, clientEvent);
            tag = clientEvent.getVersionTag();
            serverConnection.setModificationInfo(true, regionName, key);
        }
        catch (EntryNotFoundException e) {
            logger.info("During {} no entry was found for key {}", new Object[]{"invalidate", key});
        }
        catch (RegionDestroyedException rde) {
            Invalidate70.writeException(clientMessage, rde, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception e) {
            Invalidate70.checkForInterrupt(serverConnection, e);
            Invalidate70.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)e);
                }
            } else {
                logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), (Throwable)e);
            }
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessInvalidateTime(start - oldStart2);
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, pr.getNetworkHopType(), tag);
                pr.clearNetworkHopData();
            } else {
                this.writeReply(clientMessage, serverConnection, tag);
            }
        } else {
            this.writeReply(clientMessage, serverConnection, tag);
        }
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent invalidate response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
        stats.incWriteInvalidateResponseTime(DistributionStats.getStatTime() - start);
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 2;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags);
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        pr.getPrStats().incPRMetaDataSentCount();
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 2;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags);
        if (versionTag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("wrote version tag in response: {}", (Object)versionTag);
            }
            replyMsg.addObjPart(versionTag);
        } else if (logger.isDebugEnabled()) {
            logger.debug("response has no version tag");
        }
        replyMsg.addBytesPart(Invalidate70.okBytes());
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }
}

