/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogWriterImpl;

public class SecurityLogWriter
extends LogWriterImpl
implements InternalLogWriter {
    public static final String SECURITY_PREFIX = "security-";
    private final int logLevel;
    private final InternalLogWriter realLogWriter;

    public SecurityLogWriter(int level, InternalLogWriter logWriter) {
        this.logLevel = level;
        this.realLogWriter = logWriter;
    }

    @Override
    public int getLogWriterLevel() {
        return this.logLevel;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public String getConnectionName() {
        return null;
    }

    @Override
    public void put(int messageLevel, StringId messageId, Object[] parameters, Throwable throwable) {
        this.put(messageLevel, messageId.toLocalizedString(parameters), throwable);
    }

    @Override
    public void put(int messageLevel, String message, Throwable throwable) {
        this.realLogWriter.put(messageLevel, SECURITY_PREFIX + SecurityLogWriter.levelToString(messageLevel) + " " + message, throwable);
    }
}

