/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.InvalidObjectException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.management.JMX;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MXBeanProxyInvocationHandler;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.NotificationBroadCasterProxy;
import org.apache.geode.management.internal.ProxyInterface;
import org.apache.logging.log4j.Logger;

public class MBeanProxyInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LogService.getLogger();
    private final ObjectName objectName;
    private final Region<String, Object> monitoringRegion;
    private final DistributedMember member;
    private final NotificationBroadcasterSupport emitter;
    private final ProxyInterface proxyImpl;
    private final boolean isMXBean;
    private MXBeanProxyInvocationHandler mxBeanProxyInvocationHandler;

    static Object newProxyInstance(DistributedMember member, Region<String, Object> monitoringRegion, ObjectName objectName, FederationComponent federationComponent, Class interfaceClass) {
        boolean isMXBean = JMX.isMXBeanInterface(interfaceClass);
        boolean notificationBroadcaster = federationComponent.isNotificationEmitter();
        MBeanProxyInvocationHandler invocationHandler = new MBeanProxyInvocationHandler(member, objectName, monitoringRegion, isMXBean);
        Class[] interfaces = notificationBroadcaster ? new Class[]{interfaceClass, ProxyInterface.class, NotificationBroadCasterProxy.class} : new Class[]{interfaceClass, ProxyInterface.class};
        Object proxy = Proxy.newProxyInstance(MBeanProxyInvocationHandler.class.getClassLoader(), interfaces, (InvocationHandler)invocationHandler);
        return interfaceClass.cast(proxy);
    }

    private MBeanProxyInvocationHandler(DistributedMember member, ObjectName objectName, Region<String, Object> monitoringRegion, boolean isMXBean) {
        this(member, objectName, monitoringRegion, isMXBean, new NotificationBroadcasterSupport(), new ProxyInterfaceImpl());
    }

    @VisibleForTesting
    MBeanProxyInvocationHandler(DistributedMember member, ObjectName objectName, Region<String, Object> monitoringRegion, boolean isMXBean, NotificationBroadcasterSupport emitter, ProxyInterface proxyImpl) {
        this.member = member;
        this.objectName = objectName;
        this.monitoringRegion = monitoringRegion;
        this.isMXBean = isMXBean;
        this.emitter = emitter;
        this.proxyImpl = proxyImpl;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws MBeanException, ListenerNotFoundException, InvalidObjectException, OpenDataException {
        int argumentCount;
        Class<?> methodClass;
        if (logger.isTraceEnabled()) {
            logger.trace("Invoking Method {}", (Object)method.getName());
        }
        if ((methodClass = method.getDeclaringClass()).equals(NotificationBroadcaster.class) || methodClass.equals(NotificationEmitter.class)) {
            return this.invokeBroadcasterMethod(method, arguments);
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        int n = argumentCount = arguments == null ? 0 : arguments.length;
        if (methodName.equals("setLastRefreshedTime")) {
            this.proxyImpl.setLastRefreshedTime((Long)arguments[0]);
            return null;
        }
        if (methodName.equals("getLastRefreshedTime")) {
            return this.proxyImpl.getLastRefreshedTime();
        }
        if (methodName.equals("sendNotification")) {
            this.sendNotification(arguments[0]);
            return null;
        }
        if (this.shouldDoLocally(method)) {
            return this.doLocally(method, arguments);
        }
        if (this.isMXBean) {
            MXBeanProxyInvocationHandler p = this.findMXBeanProxy(this.objectName, methodClass, this);
            return p.invoke(proxy, method, arguments);
        }
        if (methodName.startsWith("get") && methodName.length() > 3 && argumentCount == 0 && !returnType.equals(Void.TYPE)) {
            return this.delegateToObjectState(methodName.substring(3));
        }
        if (methodName.startsWith("is") && methodName.length() > 2 && argumentCount == 0 && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class))) {
            return this.delegateToObjectState(methodName.substring(2));
        }
        String[] signature = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature[i] = parameterTypes[i].getName();
        }
        return this.delegateToFunctionService(this.objectName, methodName, arguments, signature);
    }

    Object delegateToObjectState(String attributeName) throws MBeanException {
        try {
            FederationComponent federation = (FederationComponent)this.monitoringRegion.get(this.objectName.toString());
            return federation.getValue(attributeName);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new MBeanException(new Exception(t.getLocalizedMessage()));
        }
    }

    Object delegateToFunctionService(ObjectName objectName, String methodName, Object[] arguments, String[] signature) throws MBeanException {
        List result;
        Object[] functionArguments = new Object[]{objectName, methodName, signature, arguments, this.member.getName()};
        try {
            ResultCollector resultCollector = FunctionService.onMember(this.member).setArguments(functionArguments).execute(ManagementConstants.MGMT_FUNCTION_ID);
            result = (List)resultCollector.getResult();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(" Exception while Executing Function {}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (logger.isDebugEnabled()) {
                logger.debug(" Error while Executing Function {}", (Object)t.getMessage(), (Object)t);
            }
            return null;
        }
        return this.checkErrors(result.get(0));
    }

    private void sendNotification(Object notification) {
        this.emitter.sendNotification((Notification)notification);
    }

    private Object checkErrors(Object lastResult) throws MBeanException {
        if (lastResult instanceof MBeanException) {
            throw (MBeanException)lastResult;
        }
        if (lastResult instanceof Exception) {
            return null;
        }
        if (lastResult instanceof Throwable) {
            return null;
        }
        return lastResult;
    }

    private Object invokeBroadcasterMethod(Method method, Object[] arguments) throws MBeanException, ListenerNotFoundException {
        String methodName = method.getName();
        int argumentCount = arguments == null ? 0 : arguments.length;
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] signature = new String[parameterTypes.length];
        switch (methodName) {
            case "addNotificationListener": {
                if (argumentCount != 3) {
                    throw new IllegalArgumentException("Bad arg count to addNotificationListener: " + argumentCount);
                }
                NotificationListener listener = (NotificationListener)arguments[0];
                NotificationFilter filter = (NotificationFilter)arguments[1];
                Object handback = arguments[2];
                this.emitter.addNotificationListener(listener, filter, handback);
                this.delegateToFunctionService(this.objectName, methodName, null, signature);
                return null;
            }
            case "removeNotificationListener": {
                NotificationListener listener = (NotificationListener)arguments[0];
                switch (argumentCount) {
                    case 1: {
                        this.emitter.removeNotificationListener(listener);
                        this.delegateToFunctionService(this.objectName, methodName, null, signature);
                        return null;
                    }
                    case 3: {
                        NotificationFilter filter = (NotificationFilter)arguments[1];
                        Object handback = arguments[2];
                        this.emitter.removeNotificationListener(listener, filter, handback);
                        this.delegateToFunctionService(this.objectName, methodName, null, signature);
                        return null;
                    }
                }
                throw new IllegalArgumentException("Bad arg count to removeNotificationListener: " + argumentCount);
            }
            case "getNotificationInfo": {
                if (arguments != null) {
                    throw new IllegalArgumentException("getNotificationInfo has args");
                }
                if (!MBeanJMXAdapter.mbeanServer.isRegistered(this.objectName)) {
                    return new MBeanNotificationInfo[0];
                }
                Object obj = this.delegateToFunctionService(this.objectName, methodName, arguments, signature);
                if (obj instanceof String) {
                    return new MBeanNotificationInfo[0];
                }
                MBeanInfo info = (MBeanInfo)obj;
                return info.getNotifications();
            }
        }
        throw new IllegalArgumentException("Bad method name: " + methodName);
    }

    private boolean shouldDoLocally(Method method) {
        String methodName = method.getName();
        if ((methodName.equals("hashCode") || methodName.equals("toString")) && method.getParameterTypes().length == 0) {
            return true;
        }
        return methodName.equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class});
    }

    private Object doLocally(Method method, Object[] arguments) {
        String methodName = method.getName();
        FederationComponent federation = (FederationComponent)this.monitoringRegion.get(this.objectName.toString());
        switch (methodName) {
            case "equals": {
                return federation.equals(arguments[0]);
            }
            case "toString": {
                return federation.toString();
            }
            case "hashCode": {
                return federation.hashCode();
            }
        }
        throw new IllegalArgumentException("Unexpected method name: " + methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MXBeanProxyInvocationHandler findMXBeanProxy(ObjectName objectName, Class<?> mbeanInterface, MBeanProxyInvocationHandler handler) {
        if (this.mxBeanProxyInvocationHandler == null) {
            MBeanProxyInvocationHandler mBeanProxyInvocationHandler = this;
            synchronized (mBeanProxyInvocationHandler) {
                try {
                    this.mxBeanProxyInvocationHandler = new MXBeanProxyInvocationHandler(objectName, mbeanInterface, handler);
                }
                catch (IllegalArgumentException e) {
                    String message = "Cannot make MXBean proxy for " + mbeanInterface.getName() + ": " + e.getMessage();
                    throw new IllegalArgumentException(message, e.getCause());
                }
            }
        }
        return this.mxBeanProxyInvocationHandler;
    }

    private static class ProxyInterfaceImpl
    implements ProxyInterface {
        private volatile long lastRefreshedTime = System.currentTimeMillis();

        private ProxyInterfaceImpl() {
        }

        @Override
        public long getLastRefreshedTime() {
            return this.lastRefreshedTime;
        }

        @Override
        public void setLastRefreshedTime(long lastRefreshedTime) {
            this.lastRefreshedTime = lastRefreshedTime;
        }
    }
}

