/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import org.apache.geode.management.internal.beans.MetricsCalculator;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;

public class StatsAverageLatency {
    private final String numberKey;
    private final String timeKey;
    private final StatType numKeyType;
    private final MBeanStatsMonitor monitor;

    public StatsAverageLatency(String numberKey, StatType numKeyType, String timeKey, MBeanStatsMonitor monitor) {
        this.numberKey = numberKey;
        this.numKeyType = numKeyType;
        this.timeKey = timeKey;
        this.monitor = monitor;
    }

    public long getAverageLatency() {
        if (this.numKeyType.equals((Object)StatType.INT_TYPE)) {
            int numberCounter = this.monitor.getStatistic(this.numberKey).intValue();
            long timeCounter = this.monitor.getStatistic(this.timeKey).longValue();
            return MetricsCalculator.getAverageLatency(numberCounter, timeCounter);
        }
        long numberCounter = this.monitor.getStatistic(this.numberKey).longValue();
        long timeCounter = this.monitor.getStatistic(this.timeKey).longValue();
        return MetricsCalculator.getAverageLatency(numberCounter, timeCounter);
    }
}

