/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.GatewayReceiverInfo;

public class GatewayReceiver
extends GroupableConfiguration<GatewayReceiverInfo> {
    public static final String GATEWAY_RECEIVERS_ENDPOINTS = "/gateways/receivers";
    private List<ClassName> gatewayTransportFilters;
    private Integer startPort;
    private Integer endPort;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private Boolean manualStart;

    @Override
    @JsonIgnore
    public String getId() {
        String id = this.getGroup();
        if (GatewayReceiver.isCluster(id)) {
            id = "cluster";
        }
        return id;
    }

    @Override
    public Links getLinks() {
        return new Links(this.getId(), GATEWAY_RECEIVERS_ENDPOINTS);
    }

    public List<ClassName> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    public void setGatewayTransportFilters(List<ClassName> gatewayTransportFilters) {
        this.gatewayTransportFilters = gatewayTransportFilters;
    }

    public Integer getStartPort() {
        return this.startPort;
    }

    public void setStartPort(Integer startPort) {
        this.startPort = startPort;
    }

    public Integer getEndPort() {
        return this.endPort;
    }

    public void setEndPort(Integer endPort) {
        this.endPort = endPort;
    }

    public Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Boolean isManualStart() {
        return this.manualStart;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = manualStart;
    }
}

