/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorBuilder;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorStatistics;
import org.apache.geode.distributed.internal.membership.gms.MembershipLocatorStatisticsNoOp;
import org.apache.geode.distributed.internal.membership.gms.TcpHandlerNoOp;
import org.apache.geode.distributed.internal.membership.gms.locator.MembershipLocatorImpl;
import org.apache.geode.distributed.internal.tcpserver.HostAddress;
import org.apache.geode.distributed.internal.tcpserver.ProtocolChecker;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.internal.serialization.DSFIDSerializer;

public final class MembershipLocatorBuilderImpl<ID extends MemberIdentifier>
implements MembershipLocatorBuilder<ID> {
    private final DSFIDSerializer serializer;
    private int port = 0;
    private HostAddress bindAddress = null;
    private ProtocolChecker protocolChecker = (socket, input, firstByte) -> false;
    private TcpHandler fallbackHandler = new TcpHandlerNoOp();
    private MembershipLocatorStatistics locatorStats = new MembershipLocatorStatisticsNoOp();
    private boolean locatorsAreCoordinators = true;
    private final TcpSocketCreator socketCreator;
    private final Path workingDirectory;
    private MembershipConfig config = new MembershipConfig(){};
    private final Supplier<ExecutorService> executorServiceSupplier;

    public MembershipLocatorBuilderImpl(TcpSocketCreator socketCreator, DSFIDSerializer serializer, Path workingDirectory, Supplier<ExecutorService> executorServiceSupplier) {
        this.socketCreator = socketCreator == null ? new TcpSocketCreatorImpl() : socketCreator;
        this.serializer = serializer;
        this.workingDirectory = workingDirectory;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    @Override
    public MembershipLocatorBuilder<ID> setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public MembershipLocatorBuilder<ID> setBindAddress(HostAddress bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    @Override
    public MembershipLocatorBuilder<ID> setConfig(MembershipConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public MembershipLocatorBuilder<ID> setProtocolChecker(ProtocolChecker protocolChecker) {
        this.protocolChecker = protocolChecker;
        return this;
    }

    @Override
    public MembershipLocatorBuilder<ID> setFallbackHandler(TcpHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
        return this;
    }

    @Override
    public MembershipLocatorBuilder<ID> setLocatorsAreCoordinators(boolean locatorsAreCoordinators) {
        this.locatorsAreCoordinators = locatorsAreCoordinators;
        return this;
    }

    @Override
    public MembershipLocatorBuilder<ID> setLocatorStats(MembershipLocatorStatistics locatorStats) {
        this.locatorStats = locatorStats;
        return this;
    }

    @Override
    public MembershipLocator<ID> create() throws UnknownHostException, MembershipConfigurationException {
        return new MembershipLocatorImpl(this.port, this.bindAddress, this.protocolChecker, this.executorServiceSupplier, this.socketCreator, this.serializer.getObjectSerializer(), this.serializer.getObjectDeserializer(), this.fallbackHandler, this.locatorsAreCoordinators, this.locatorStats, this.workingDirectory, this.config);
    }
}

