/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#ifndef GEODE_MAPENTRYIMPLMOCK_H_
#define GEODE_MAPENTRYIMPLMOCK_H_

#include <gmock/gmock.h>

#include "MapEntryImpl.hpp"

namespace apache {
namespace geode {
namespace client {
class MapEntryImplMock : public MapEntryImpl {
 public:
  explicit MapEntryImplMock(const std::shared_ptr<CacheableKey>& key)
      : MapEntryImpl(key) {}

  MOCK_METHOD0(getLRUProperties, LRUEntryProperties&());
  MOCK_METHOD1(addTracker, int(std::shared_ptr<MapEntry>&));
  MOCK_METHOD0(removeTracker, std::pair<bool, int>());
  MOCK_CONST_METHOD0(getTrackingNumber, int());
  MOCK_CONST_METHOD0(getUpdateCount, int());
  MOCK_METHOD1(incrementUpdateCount, int(std::shared_ptr<MapEntry>&));
};
}  // namespace client
}  // namespace geode
}  // namespace apache

#endif  // GEODE_MAPENTRYIMPLMOCK_H_
