/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.EOFException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class CloseConnectionOp {
    public static void execute(Connection con, boolean keepAlive) throws Exception {
        CloseConnectionOpImpl op = new CloseConnectionOpImpl(keepAlive);
        try {
            con.execute(op);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private CloseConnectionOp() {
    }

    private static class CloseConnectionOpImpl
    extends AbstractOp {
        public CloseConnectionOpImpl(boolean keepAlive) {
            super(18, 1);
            this.getMessage().addRawPart(new byte[]{(byte)(keepAlive ? 1 : 0)}, false);
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startCloseCon();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCloseConSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCloseCon(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

