/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOpWithTimeout;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExecuteFunctionHelper;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteRegionFunctionOp {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_RETRY_INITIAL_VALUE = -1;

    private ExecuteRegionFunctionOp() {
    }

    static void execute(ExecutablePool pool, ResultCollector resultCollector, int retryAttempts, boolean isHA, ExecuteRegionFunctionOpImpl op, boolean isReexecute, Set<String> failedNodes) {
        int maxRetryAttempts;
        int n = maxRetryAttempts = retryAttempts > 0 ? retryAttempts : -1;
        if (!isHA) {
            maxRetryAttempts = 0;
        }
        while (true) {
            try {
                if (isReexecute) {
                    failedNodes = ExecuteRegionFunctionOp.ensureMutability(failedNodes);
                    op = new ExecuteRegionFunctionOpImpl(op, 1, failedNodes);
                }
                pool.execute(op, 0);
                return;
            }
            catch (InternalFunctionInvocationTargetException e) {
                resultCollector.clearResults();
                if (!isHA) {
                    return;
                }
                isReexecute = true;
                Set<String> failedNodesIds = e.getFailedNodeSet();
                failedNodes = ExecuteRegionFunctionOp.ensureMutability(failedNodes);
                failedNodes.clear();
                if (failedNodesIds == null) continue;
                failedNodes.addAll(failedNodesIds);
                continue;
            }
            catch (NoAvailableServersException | ServerOperationException failedException) {
                throw failedException;
            }
            catch (ServerConnectivityException se) {
                if (maxRetryAttempts == -1) {
                    maxRetryAttempts = ((PoolImpl)pool).calculateRetryAttempts(se);
                }
                if (maxRetryAttempts-- < 1) {
                    throw se;
                }
                isReexecute = true;
                resultCollector.clearResults();
                failedNodes = ExecuteRegionFunctionOp.ensureMutability(failedNodes);
                failedNodes.clear();
                continue;
            }
            break;
        }
    }

    private static Set<String> ensureMutability(Set<String> failedNodes) {
        if (failedNodes == Collections.EMPTY_SET) {
            return new HashSet<String>();
        }
        return failedNodes;
    }

    static class ExecuteRegionFunctionOpImpl
    extends AbstractOpWithTimeout {
        private final ResultCollector resultCollector;
        private Function function;
        private byte isReExecute = 0;
        private final String regionName;
        private final ServerRegionFunctionExecutor executor;
        private final byte hasResult;
        private Set<String> failedNodes;
        private final String functionId;
        private final boolean executeOnBucketSet;
        private final boolean isHA;
        private FunctionException functionException;
        private static final int PART_COUNT = 8;

        private static int getMessagePartCount(int filterSize, int removedNodesSize) {
            return 8 + filterSize + removedNodesSize;
        }

        private void fillMessage(String region, Function function, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, Set<String> removedNodes, byte functionState, byte flags) {
            Set routingObjects = serverRegionExecutor.getFilter();
            Object args = serverRegionExecutor.getArguments();
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.addBytes(functionState);
            this.getMessage().addStringPart(region, true);
            if (function != null && serverRegionExecutor.isFnSerializationReqd()) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(functionId);
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addBytesPart(new byte[]{flags});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object e : routingObjects) {
                this.getMessage().addStringOrObjPart(e);
            }
            this.getMessage().addIntPart(removedNodes.size());
            for (Object object : removedNodes) {
                this.getMessage().addStringOrObjPart(object);
            }
        }

        ExecuteRegionFunctionOpImpl(String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector rc, int timeoutMs) {
            super(59, ExecuteRegionFunctionOpImpl.getMessagePartCount(serverRegionExecutor.getFilter().size(), 0), timeoutMs);
            this.executeOnBucketSet = serverRegionExecutor.getExecuteOnBucketSetFlag();
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, this.isReExecute);
            byte functionState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            this.failedNodes = Collections.emptySet();
            this.fillMessage(region, function, function.getId(), serverRegionExecutor, this.failedNodes, functionState, flags);
            this.resultCollector = rc;
            this.regionName = region;
            this.function = function;
            this.functionId = function.getId();
            this.executor = serverRegionExecutor;
            this.hasResult = functionState;
            this.isHA = function.isHA();
        }

        ExecuteRegionFunctionOpImpl() {
            super(59, 0, 0);
            this.resultCollector = null;
            this.function = null;
            this.isReExecute = 0;
            this.regionName = "";
            this.executor = null;
            this.hasResult = 0;
            this.failedNodes = null;
            this.functionId = null;
            this.executeOnBucketSet = true;
            this.isHA = true;
        }

        ExecuteRegionFunctionOpImpl(String region, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector rc, byte hasResult, boolean isHA, boolean optimizeForWrite, boolean calculateFnState, int timeoutMs) {
            super(59, ExecuteRegionFunctionOpImpl.getMessagePartCount(serverRegionExecutor.getFilter().size(), 0), timeoutMs);
            byte functionState = hasResult;
            if (calculateFnState) {
                functionState = AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite);
            }
            this.executeOnBucketSet = serverRegionExecutor.getExecuteOnBucketSetFlag();
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, this.isReExecute);
            this.failedNodes = Collections.emptySet();
            this.fillMessage(region, null, functionId, serverRegionExecutor, this.failedNodes, functionState, flags);
            this.resultCollector = rc;
            this.regionName = region;
            this.functionId = functionId;
            this.executor = serverRegionExecutor;
            this.hasResult = functionState;
            this.isHA = isHA;
        }

        ExecuteRegionFunctionOpImpl(ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl newop) {
            this(newop.getRegionName(), newop.getFunctionId(), newop.getExecutor(), newop.getResultCollector(), newop.getHasResult(), newop.isHA(), newop.optimizeForWrite(), false, newop.getTimeoutMs());
        }

        ExecuteRegionFunctionOpImpl(ExecuteRegionFunctionOpImpl op, byte isReExecute, Set<String> removedNodes) {
            super(59, ExecuteRegionFunctionOpImpl.getMessagePartCount(op.executor.getFilter().size(), removedNodes.size()), op.getTimeoutMs());
            this.isReExecute = isReExecute;
            this.resultCollector = op.resultCollector;
            this.function = op.function;
            this.functionId = op.functionId;
            this.regionName = op.regionName;
            this.executor = op.executor;
            this.hasResult = op.hasResult;
            this.failedNodes = op.failedNodes;
            this.executeOnBucketSet = op.executeOnBucketSet;
            this.isHA = op.isHA;
            if (isReExecute == 1) {
                this.resultCollector.endResults();
                this.resultCollector.clearResults();
            }
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, isReExecute);
            this.fillMessage(this.regionName, this.function, this.functionId, this.executor, removedNodes, this.hasResult, flags);
        }

        private void addBytes(byte functionStateOrHasResult) {
            if (this.getTimeoutMs() == 0) {
                this.getMessage().addBytesPart(new byte[]{functionStateOrHasResult});
            } else {
                byte[] bytes = new byte[5];
                bytes[0] = functionStateOrHasResult;
                Part.encodeInt(this.getTimeoutMs(), bytes, 1);
                this.getMessage().addBytesPart(bytes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage executeFunctionResponseMsg = (ChunkedMessage)msg;
            try {
                executeFunctionResponseMsg.readHeader();
                switch (executeFunctionResponseMsg.getMessageType()) {
                    case 60: {
                        String s;
                        boolean isDebugEnabled = logger.isDebugEnabled();
                        if (isDebugEnabled) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received message of type EXECUTE_REGION_FUNCTION_RESULT. The number of parts are : {}", (Object)executeFunctionResponseMsg.getNumberOfParts());
                        }
                        boolean throwServerOp = false;
                        do {
                            DistributedMember memberID;
                            executeFunctionResponseMsg.receiveChunk();
                            Object resultResponse = executeFunctionResponseMsg.getPart(0).getObject();
                            Object result = resultResponse instanceof ArrayList ? ((ArrayList)resultResponse).get(0) : resultResponse;
                            if (result instanceof FunctionException) {
                                FunctionException ex = (FunctionException)result;
                                if (ex instanceof InternalFunctionException) {
                                    Throwable cause = ex.getCause();
                                    memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                    this.resultCollector.addResult(memberID, cause);
                                    FunctionStatsManager.getFunctionStats(this.functionId, this.executor.getRegion().getSystem()).incResultsReceived();
                                    continue;
                                }
                                if (((FunctionException)result).getCause() instanceof InternalFunctionInvocationTargetException) {
                                    InternalFunctionInvocationTargetException ifite = (InternalFunctionInvocationTargetException)ex.getCause();
                                    this.failedNodes = ExecuteRegionFunctionOp.ensureMutability(this.failedNodes);
                                    this.failedNodes.addAll(ifite.getFailedNodeSet());
                                    this.addFunctionException((FunctionException)result);
                                    continue;
                                }
                                this.addFunctionException((FunctionException)result);
                                continue;
                            }
                            if (result instanceof Throwable) {
                                Throwable t = (Throwable)result;
                                if (this.functionException == null) {
                                    FunctionInvocationTargetException fite;
                                    if (result instanceof BucketMovedException) {
                                        fite = this.isHA ? new InternalFunctionInvocationTargetException(((BucketMovedException)result).getMessage()) : new FunctionInvocationTargetException(((BucketMovedException)result).getMessage());
                                        this.functionException = new FunctionException(fite);
                                        this.functionException.addException(fite);
                                        continue;
                                    }
                                    if (result instanceof CacheClosedException) {
                                        fite = this.isHA ? new InternalFunctionInvocationTargetException(((CacheClosedException)result).getMessage()) : new FunctionInvocationTargetException(((CacheClosedException)result).getMessage());
                                        if (resultResponse instanceof ArrayList) {
                                            memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                            this.failedNodes = ExecuteRegionFunctionOp.ensureMutability(this.failedNodes);
                                            this.failedNodes.add(memberID.getId());
                                        }
                                        this.functionException = new FunctionException(fite);
                                        this.functionException.addException(fite);
                                        continue;
                                    }
                                    throwServerOp = true;
                                    this.functionException = new FunctionException(t);
                                    this.functionException.addException(t);
                                    continue;
                                }
                                this.functionException.addException(t);
                                continue;
                            }
                            DistributedMember memberID2 = (DistributedMember)((ArrayList)resultResponse).get(1);
                            this.resultCollector.addResult(memberID2, result);
                            FunctionStatsManager.getFunctionStats(this.functionId, this.executor.getRegion().getSystem()).incResultsReceived();
                        } while (!executeFunctionResponseMsg.isLastChunk());
                        if (isDebugEnabled) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received all the results from server successfully.");
                        }
                        if (this.isHA && throwServerOp) {
                            s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, this.functionException);
                        }
                        if (this.functionException != null) {
                            throw this.functionException;
                        }
                        this.resultCollector.endResults();
                        s = null;
                        return s;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received message of type EXCEPTION. The number of parts are : {}", (Object)executeFunctionResponseMsg.getNumberOfParts());
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        Part part0 = executeFunctionResponseMsg.getPart(0);
                        Object obj = part0.getObject();
                        if (obj instanceof FunctionException) {
                            FunctionException ex = (FunctionException)obj;
                            if (((FunctionException)obj).getCause() instanceof InternalFunctionInvocationTargetException) {
                                InternalFunctionInvocationTargetException ifite = (InternalFunctionInvocationTargetException)ex.getCause();
                                this.failedNodes = ExecuteRegionFunctionOp.ensureMutability(this.failedNodes);
                                this.failedNodes.addAll(ifite.getFailedNodeSet());
                            }
                            throw ex;
                        }
                        if (obj instanceof Throwable) {
                            String s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, (Throwable)obj);
                        }
                        break;
                    }
                    case 61: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received message of type EXECUTE_REGION_FUNCTION_ERROR");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        String errorMessage = executeFunctionResponseMsg.getPart(0).getString();
                        throw new ServerOperationException(errorMessage);
                    }
                    default: {
                        throw new InternalGemFireError("Unknown message type " + executeFunctionResponseMsg.getMessageType());
                    }
                }
            }
            finally {
                executeFunctionResponseMsg.clear();
            }
            return null;
        }

        void addFunctionException(FunctionException result) {
            if (result.getCause() instanceof FunctionInvocationTargetException) {
                if (this.functionException == null) {
                    this.functionException = result;
                }
                this.functionException.addException(result.getCause());
            } else if (result instanceof FunctionInvocationTargetException) {
                if (this.functionException == null) {
                    this.functionException = new FunctionException(result);
                }
                this.functionException.addException(result);
            } else {
                if (this.functionException == null) {
                    this.functionException = result;
                }
                this.functionException.addException(result);
            }
        }

        FunctionException getFunctionException() {
            return this.functionException;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 61;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        protected String getOpName() {
            return "executeRegionFunction";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }
    }
}

