/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

public class UniqueIdGenerator {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private final long[] units;
    private final int MAX_ID;
    private int ctr = 0;
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private static final long WORD_MASK = -1L;

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private void setBit(int bitIndex) {
        int unitIndex = UniqueIdGenerator.unitIndex(bitIndex);
        long bit = UniqueIdGenerator.bit(bitIndex);
        int n = unitIndex;
        this.units[n] = this.units[n] | bit;
    }

    private void clearBit(int bitIndex) {
        int unitIndex = UniqueIdGenerator.unitIndex(bitIndex);
        long bit = UniqueIdGenerator.bit(bitIndex);
        int n = unitIndex;
        this.units[n] = this.units[n] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static int trailingZeroCnt(long val) {
        int byteVal = (int)val & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal];
        }
        byteVal = (int)(val >>> 8) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 8;
        }
        byteVal = (int)(val >>> 16) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 16;
        }
        byteVal = (int)(val >>> 24) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 24;
        }
        byteVal = (int)(val >>> 32) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 32;
        }
        byteVal = (int)(val >>> 40) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 40;
        }
        byteVal = (int)(val >>> 48) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 48;
        }
        byteVal = (int)(val >>> 56) & 0xFF;
        return trailingZeroTable[byteVal] + 56;
    }

    private int nextClearBit(int fromIndex) {
        int testIndex;
        int u = UniqueIdGenerator.unitIndex(fromIndex);
        long unit = this.units[u] >> (testIndex = fromIndex & 0x3F);
        if (unit == -1L >> testIndex) {
            testIndex = 0;
        }
        while (unit == -1L && u < this.units.length - 1) {
            unit = this.units[++u];
        }
        if (unit == -1L) {
            return -1;
        }
        int result = unit == 0L ? u * 64 + testIndex : u * 64 + (testIndex += UniqueIdGenerator.trailingZeroCnt(unit ^ 0xFFFFFFFFFFFFFFFFL));
        if (result > this.MAX_ID || result < 0) {
            return -1;
        }
        return result;
    }

    public UniqueIdGenerator(int numIds) {
        if (numIds <= 0) {
            throw new IllegalArgumentException("numIds < 0");
        }
        this.units = new long[UniqueIdGenerator.unitIndex(numIds - 1) + 1];
        this.MAX_ID = numIds - 1;
        this.ctr = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int obtain() {
        UniqueIdGenerator uniqueIdGenerator = this;
        synchronized (uniqueIdGenerator) {
            int candidate = this.ctr;
            int result = this.nextClearBit(candidate);
            if (result == -1 && candidate != 0) {
                result = this.nextClearBit(0);
            }
            if (result == -1) {
                throw new IllegalStateException("Ran out of message ids");
            }
            this.setBit(result);
            this.ctr = result == this.MAX_ID ? 0 : result + 1;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int id) {
        if (id < 0) {
            throw new IllegalArgumentException(String.format("negative id: %s", id));
        }
        if (id > this.MAX_ID) {
            throw new IllegalArgumentException(String.format("id > MAX_ID: %s", id));
        }
        UniqueIdGenerator uniqueIdGenerator = this;
        synchronized (uniqueIdGenerator) {
            this.clearBit(id);
        }
    }
}

