/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import org.apache.geode.Statistics;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueStats;
import org.apache.geode.management.internal.beans.stats.GatewaySenderOverflowMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class AsyncEventQueueMBeanBridge {
    private AsyncEventQueueImpl queueImpl;
    private MBeanStatsMonitor monitor;
    private GatewaySenderOverflowMonitor overflowMonitor;
    private StatsRate lruEvictionsRate;

    public AsyncEventQueueMBeanBridge(AsyncEventQueue queue) {
        this.queueImpl = (AsyncEventQueueImpl)queue;
        this.monitor = new MBeanStatsMonitor("AsyncEventQueueMXBeanMonitor");
        this.overflowMonitor = new GatewaySenderOverflowMonitor("GatewaySenderMXBeanOverflowMonitor");
        this.addAsyncEventQueueStats(this.queueImpl.getStatistics());
        this.initializeStats();
    }

    public AsyncEventQueueMBeanBridge() {
        this.monitor = new MBeanStatsMonitor("AsyncEventQueueMXBeanMonitor");
    }

    public void addAsyncEventQueueStats(AsyncEventQueueStats asyncEventQueueStats) {
        this.monitor.addStatisticsToMonitor(asyncEventQueueStats.getStats());
    }

    public void addOverflowStatistics(Statistics statistics) {
        if (statistics != null) {
            this.overflowMonitor.addStatisticsToMonitor(statistics);
        }
    }

    private void initializeStats() {
        this.lruEvictionsRate = new StatsRate("lruEvictions", StatType.LONG_TYPE, (MBeanStatsMonitor)this.overflowMonitor);
    }

    public String getAsyncEventListener() {
        return this.queueImpl.getAsyncEventListener().getClass().getCanonicalName();
    }

    public int getBatchSize() {
        return this.queueImpl.getBatchSize();
    }

    public int getBatchTimeInteval() {
        return this.queueImpl.getBatchTimeInterval();
    }

    public boolean isBatchConflationEnabled() {
        return this.queueImpl.isBatchConflationEnabled();
    }

    public String getId() {
        return this.queueImpl.getId();
    }

    public int getMaximumQueueMemory() {
        return this.queueImpl.getMaximumQueueMemory();
    }

    public String getOverflowDiskStoreName() {
        return this.queueImpl.getDiskStoreName();
    }

    public boolean isPersistent() {
        return this.queueImpl.isPersistent();
    }

    public boolean isParallel() {
        return this.queueImpl.isParallel();
    }

    public boolean isPrimary() {
        return this.queueImpl.isPrimary();
    }

    public int getDispatcherThreads() {
        return this.queueImpl.getDispatcherThreads();
    }

    public String getOrderPolicy() {
        return this.queueImpl.getOrderPolicy() != null ? this.queueImpl.getOrderPolicy().name() : null;
    }

    public boolean isDiskSynchronous() {
        return this.queueImpl.isDiskSynchronous();
    }

    public int getEventQueueSize() {
        return this.getStatistic("eventQueueSize").intValue();
    }

    public float getLRUEvictionsRate() {
        return this.lruEvictionsRate.getRate();
    }

    public long getEntriesOverflowedToDisk() {
        return this.overflowMonitor.getStatistic("entriesOnlyOnDisk").longValue();
    }

    public long getBytesOverflowedToDisk() {
        return this.overflowMonitor.getStatistic("bytesOnlyOnDisk").longValue();
    }

    private Number getStatistic(String statName) {
        if (this.monitor != null) {
            return this.monitor.getStatistic(statName);
        }
        return 0;
    }

    public void stopMonitor() {
        this.monitor.stopListener();
    }

    public boolean isDispatchingPaused() {
        return this.queueImpl.isDispatchingPaused();
    }
}

