/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.util;

import com.healthmarketscience.rmiio.PacketOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OutputStreamAdapter {
    private OutputStreamAdapter() {
    }

    public abstract OutputStream getOutputStream();

    public abstract void writePacket(byte[] var1) throws IOException;

    public static OutputStreamAdapter create(OutputStream istream) {
        if (istream instanceof PacketOutputStream) {
            return new PacketAdapter((PacketOutputStream)istream);
        }
        return new DefaultAdapter(istream);
    }

    private static class DefaultAdapter
    extends OutputStreamAdapter {
        private final OutputStream _ostream;

        private DefaultAdapter(OutputStream ostream) {
            this._ostream = ostream;
        }

        public OutputStream getOutputStream() {
            return this._ostream;
        }

        public void writePacket(byte[] packet) throws IOException {
            this._ostream.write(packet, 0, packet.length);
        }
    }

    private static class PacketAdapter
    extends OutputStreamAdapter {
        private final PacketOutputStream _postream;

        private PacketAdapter(PacketOutputStream postream) {
            this._postream = postream;
        }

        public PacketOutputStream getOutputStream() {
            return this._postream;
        }

        public void writePacket(byte[] packet) throws IOException {
            this._postream.writePacket(packet);
        }
    }
}

