/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import java.util.Arrays;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.tag.MetadataObjectDTO;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class MetadataObjectListResponse
extends BaseResponse {
    @JsonProperty(value="metadataObjects")
    private final MetadataObjectDTO[] metadataObjects;

    public MetadataObjectListResponse(MetadataObjectDTO[] metadataObjects) {
        super(0);
        this.metadataObjects = metadataObjects;
    }

    public MetadataObjectListResponse() {
        this.metadataObjects = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.metadataObjects != null, "metadataObjects must be non-null");
        Arrays.stream(this.metadataObjects).forEach(object -> Preconditions.checkArgument(object != null && StringUtils.isNotBlank(object.name()) && object.type() != null, "metadataObject must not be null and it's field cannot null or empty"));
    }

    public MetadataObjectDTO[] getMetadataObjects() {
        return this.metadataObjects;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataObjectListResponse)) {
            return false;
        }
        MetadataObjectListResponse other = (MetadataObjectListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getMetadataObjects(), other.getMetadataObjects());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetadataObjectListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getMetadataObjects());
        return result;
    }

    @Override
    public String toString() {
        return "MetadataObjectListResponse(metadataObjects=" + Arrays.deepToString(this.getMetadataObjects()) + ")";
    }
}

