/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.hive;

import com.google.common.collect.ImmutableSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.session.PropertyMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.distributions.Strategy;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.hive.HiveDataTypeTransformer;
import org.apache.gravitino.trino.connector.catalog.hive.HiveSchemaPropertyConverter;
import org.apache.gravitino.trino.connector.catalog.hive.HiveTablePropertyConverter;
import org.apache.gravitino.trino.connector.catalog.hive.SortingColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;

public class HiveMetadataAdapter
extends CatalogConnectorMetadataAdapter {
    private final PropertyConverter tableConverter = new HiveTablePropertyConverter();
    private final PropertyConverter schemaConverter = new HiveSchemaPropertyConverter();
    private static final Set<String> HIVE_PROPERTIES_TO_REMOVE = ImmutableSet.of((Object)"partitioned_by", (Object)"bucketed_by", (Object)"bucket_count", (Object)"sorted_by");

    public HiveMetadataAdapter(List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> columnProperties) {
        super(schemaProperties, tableProperties, columnProperties, new HiveDataTypeTransformer());
    }

    @Override
    public Map<String, Object> toTrinoTableProperties(Map<String, String> properties) {
        Map objectMap = this.tableConverter.gravitinoToEngineProperties(properties);
        return super.toTrinoTableProperties(objectMap);
    }

    @Override
    public Map<String, Object> toTrinoSchemaProperties(Map<String, String> properties) {
        Map objectMap = this.schemaConverter.gravitinoToEngineProperties(properties);
        return super.toTrinoSchemaProperties(objectMap);
    }

    @Override
    public Map<String, String> toGravitinoTableProperties(Map<String, Object> properties) {
        Map stringMap = this.tableConverter.engineToGravitinoProperties(properties);
        return super.toGravitinoTableProperties(stringMap);
    }

    @Override
    public Map<String, String> toGravitinoSchemaProperties(Map<String, Object> properties) {
        Map stringMap = this.schemaConverter.engineToGravitinoProperties(properties);
        return super.toGravitinoSchemaProperties(stringMap);
    }

    @Override
    public GravitinoTable createTable(ConnectorTableMetadata tableMetadata) {
        List sortColumns;
        String tableName = tableMetadata.getTableSchema().getTable().getTableName();
        String schemaName = tableMetadata.getTableSchema().getTable().getSchemaName();
        String comment = tableMetadata.getComment().orElse("");
        Map propertyMap = tableMetadata.getProperties();
        List partitionColumns = propertyMap.containsKey("partitioned_by") ? (List)propertyMap.get("partitioned_by") : Collections.emptyList();
        List bucketColumns = propertyMap.containsKey("bucketed_by") ? (List)propertyMap.get("bucketed_by") : Collections.emptyList();
        int bucketCount = propertyMap.containsKey("bucket_count") ? (Integer)propertyMap.get("bucket_count") : 0;
        List list = sortColumns = propertyMap.containsKey("sorted_by") ? (List)propertyMap.get("sorted_by") : Collections.emptyList();
        if (!sortColumns.isEmpty() && (bucketColumns.isEmpty() || bucketCount == 0)) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Sort columns can only be set when bucket columns and bucket count are set");
        }
        Map<String, String> properties = this.toGravitinoTableProperties(this.removeKeys(tableMetadata.getProperties(), HIVE_PROPERTIES_TO_REMOVE));
        ArrayList<GravitinoColumn> columns = new ArrayList<GravitinoColumn>();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            columns.add(new GravitinoColumn(column.getName(), this.dataTypeTransformer.getGravitinoType(column.getType()), i, column.getComment(), column.isNullable()));
        }
        GravitinoTable gravitinoTable = new GravitinoTable(schemaName, tableName, columns, comment, properties);
        if (!partitionColumns.isEmpty()) {
            Transform[] partitioning = (Transform[])partitionColumns.stream().map(Transforms::identity).toArray(Transform[]::new);
            gravitinoTable.setPartitioning(partitioning);
        }
        if (!bucketColumns.isEmpty()) {
            Expression[] bucketing = (Expression[])bucketColumns.stream().map(NamedReference::field).toArray(Expression[]::new);
            gravitinoTable.setDistribution(Distributions.of((Strategy)Strategy.HASH, (int)bucketCount, (Expression[])bucketing));
        }
        if (!sortColumns.isEmpty()) {
            SortOrder[] sorting = (SortOrder[])sortColumns.stream().map(sortingColumn -> {
                NamedReference.FieldReference expression = NamedReference.field((String)sortingColumn.getColumnName());
                SortDirection sortDirection = sortingColumn.getOrder() == SortingColumn.Order.ASCENDING ? SortDirection.ASCENDING : SortDirection.DESCENDING;
                return SortOrders.of((Expression)expression, (SortDirection)sortDirection);
            }).toArray(SortOrder[]::new);
            gravitinoTable.setSortOrders(sorting);
        }
        return gravitinoTable;
    }

    @Override
    public ConnectorTableMetadata getTableMetadata(GravitinoTable gravitinoTable) {
        SchemaTableName schemaTableName = new SchemaTableName(gravitinoTable.getSchemaName(), gravitinoTable.getName());
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        for (GravitinoColumn column : gravitinoTable.getColumns()) {
            columnMetadataList.add(this.getColumnMetadata(column));
        }
        Map<String, Object> properties = this.toTrinoTableProperties(gravitinoTable.getProperties());
        if (ArrayUtils.isNotEmpty((Object[])gravitinoTable.getPartitioning())) {
            properties.put("partitioned_by", gravitinoTable.getPartitioning().length > 0 ? Arrays.stream(gravitinoTable.getPartitioning()).map(ts -> ((Transform.SingleFieldTransform)ts).fieldName()[0].toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()) : Collections.emptyList());
        }
        if (gravitinoTable.getDistribution() != null && !Distributions.NONE.equals(gravitinoTable.getDistribution())) {
            properties.put("bucketed_by", Arrays.stream(gravitinoTable.getDistribution().expressions()).map(ts -> ((NamedReference)ts).fieldName()[0].toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()));
            properties.put("bucket_count", gravitinoTable.getDistribution().number());
        }
        if (ArrayUtils.isNotEmpty((Object[])gravitinoTable.getSortOrders())) {
            properties.put("sorted_by", Arrays.stream(gravitinoTable.getSortOrders()).map(sortOrder -> {
                Expression expression = sortOrder.expression();
                SortDirection sortDirection = sortOrder.direction() == SortDirection.ASCENDING ? SortDirection.ASCENDING : SortDirection.DESCENDING;
                SortingColumn.Order order = sortDirection == SortDirection.ASCENDING ? SortingColumn.Order.ASCENDING : SortingColumn.Order.DESCENDING;
                return new SortingColumn(((NamedReference)expression).fieldName()[0].toLowerCase(Locale.ENGLISH), order);
            }).collect(Collectors.toList()));
        }
        return new ConnectorTableMetadata(schemaTableName, columnMetadataList, properties, Optional.ofNullable(gravitinoTable.getComment()));
    }
}

