/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth;

import java.util.Collections;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.DecoratingDirectory;
import org.apache.guacamole.net.auth.DelegatingUserContext;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.TokenInjectingConnection;
import org.apache.guacamole.net.auth.TokenInjectingConnectionGroup;
import org.apache.guacamole.net.auth.UserContext;

public class TokenInjectingUserContext
extends DelegatingUserContext {
    private final Map<String, String> tokens;

    public TokenInjectingUserContext(UserContext userContext, Map<String, String> tokens) {
        super(userContext);
        this.tokens = tokens;
    }

    public TokenInjectingUserContext(UserContext userContext) {
        this(userContext, Collections.emptyMap());
    }

    protected Map<String, String> getTokens(Connection connection) throws GuacamoleException {
        return this.tokens;
    }

    protected void addTokens(Connection connection, Map<String, String> tokens) throws GuacamoleException {
        tokens.putAll(this.getTokens(connection));
    }

    protected Map<String, String> getTokens(ConnectionGroup connectionGroup) throws GuacamoleException {
        return this.tokens;
    }

    protected void addTokens(ConnectionGroup connectionGroup, Map<String, String> tokens) throws GuacamoleException {
        tokens.putAll(this.getTokens(connectionGroup));
    }

    @Override
    public Directory<ConnectionGroup> getConnectionGroupDirectory() throws GuacamoleException {
        return new DecoratingDirectory<ConnectionGroup>(super.getConnectionGroupDirectory()){

            @Override
            protected ConnectionGroup decorate(final ConnectionGroup object) throws GuacamoleException {
                return new TokenInjectingConnectionGroup(object){

                    @Override
                    protected void addTokens(Map<String, String> tokens) throws GuacamoleException {
                        TokenInjectingUserContext.this.addTokens(object, tokens);
                    }
                };
            }

            @Override
            protected ConnectionGroup undecorate(ConnectionGroup object) throws GuacamoleException {
                return ((TokenInjectingConnectionGroup)object).getDelegateConnectionGroup();
            }
        };
    }

    @Override
    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return new DecoratingDirectory<Connection>(super.getConnectionDirectory()){

            @Override
            protected Connection decorate(final Connection object) throws GuacamoleException {
                return new TokenInjectingConnection(object){

                    @Override
                    protected void addTokens(Map<String, String> tokens) throws GuacamoleException {
                        TokenInjectingUserContext.this.addTokens(object, tokens);
                    }
                };
            }

            @Override
            protected Connection undecorate(Connection object) throws GuacamoleException {
                return ((TokenInjectingConnection)object).getDelegateConnection();
            }
        };
    }
}

