/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AbstractUserContext;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleConnection;
import org.apache.guacamole.net.auth.simple.SimpleDirectory;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleUser;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class SimpleUserContext
extends AbstractUserContext {
    private final AuthenticationProvider authProvider;
    private final String username;
    private final Directory<Connection> connectionDirectory;

    public SimpleUserContext(AuthenticationProvider authProvider, Map<String, GuacamoleConfiguration> configs) {
        this(authProvider, "", configs);
    }

    public SimpleUserContext(AuthenticationProvider authProvider, String username, Map<String, GuacamoleConfiguration> configs) {
        this(authProvider, username, configs, false);
    }

    public SimpleUserContext(AuthenticationProvider authProvider, String username, Map<String, GuacamoleConfiguration> configs, boolean interpretTokens) {
        ConcurrentHashMap<String, SimpleConnection> connections = new ConcurrentHashMap<String, SimpleConnection>(configs.size());
        for (Map.Entry<String, GuacamoleConfiguration> configEntry : configs.entrySet()) {
            String identifier = configEntry.getKey();
            GuacamoleConfiguration config = configEntry.getValue();
            SimpleConnection connection = new SimpleConnection(identifier, identifier, config, interpretTokens);
            connection.setParentIdentifier("ROOT");
            connections.put(identifier, connection);
        }
        this.username = username;
        this.authProvider = authProvider;
        this.connectionDirectory = new SimpleDirectory(connections);
    }

    @Override
    public User self() {
        return new SimpleUser(this.username){

            @Override
            public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection<String>)SimpleUserContext.this.getConnectionDirectory().getIdentifiers());
            }

            @Override
            public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection<String>)SimpleUserContext.this.getConnectionGroupDirectory().getIdentifiers());
            }
        };
    }

    @Override
    public Object getResource() throws GuacamoleException {
        return null;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    @Override
    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return this.connectionDirectory;
    }
}

