/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.properties;

import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.properties.GuacamoleProperty;

public abstract class TimeZoneGuacamoleProperty
implements GuacamoleProperty<TimeZone> {
    public static final Pattern GMT_REGEX = Pattern.compile("^GMT([+-](0|00)((:)?00)?)?$");

    @Override
    public TimeZone parseValue(String value) throws GuacamoleException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        TimeZone tz = TimeZone.getTimeZone(value);
        if (!GMT_REGEX.matcher(value).matches() && GMT_REGEX.matcher(tz.getID()).matches()) {
            throw new GuacamoleServerException("Property \"" + this.getName() + "\" does not specify a valid time zone.");
        }
        return tz;
    }
}

