/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hbase.HBCKFsTableDescriptors;
import org.apache.hbase.HBCKFsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingTableDescriptorGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MissingTableDescriptorGenerator.class);
    private final Configuration configuration;
    private FileSystem fs;
    private Path rootDir;

    public MissingTableDescriptorGenerator(Configuration configuration) throws IOException {
        this.configuration = configuration;
        this.rootDir = HBCKFsUtils.getRootDir(this.configuration);
        this.fs = this.rootDir.getFileSystem(this.configuration);
    }

    public void generateTableDescriptorFileIfMissing(String tableNameAsString) {
        TableName tableName = TableName.valueOf((String)tableNameAsString);
        this.assertTableFolderIsPresent(tableName);
        if (this.checkIfTableInfoPresent(tableName)) {
            LOG.info("Table descriptor already exists, exiting without changing anything.");
            return;
        }
        Optional<TableDescriptor> tableDescriptorFromMaster = this.getTableDescriptorFromMaster(tableName);
        HBCKFsTableDescriptors fstd = new HBCKFsTableDescriptors(this.fs, this.rootDir);
        try {
            if (tableDescriptorFromMaster.isPresent()) {
                LOG.info("Table descriptor found in the cache of HBase Master, writing it to the file system.");
                fstd.createTableDescriptor(tableDescriptorFromMaster.get(), false);
                LOG.info("Table descriptor written successfully. Orphan table {} fixed.", (Object)tableName);
            } else {
                this.generateDefaultTableInfo(fstd, tableName);
                LOG.info("Table descriptor written successfully.");
                LOG.warn("Orphan table {} fixed with a default .tableinfo file. It is strongly recommended to review the TableDescriptor and modify if necessary.", (Object)tableName);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while writing the table descriptor to the file system for table {}", (Object)tableName, (Object)e);
        }
    }

    private void assertTableFolderIsPresent(TableName tableName) {
        Path tableDir = HBCKFsUtils.getTableDir(this.rootDir, tableName);
        try {
            if (!this.fs.exists(tableDir)) {
                throw new IllegalStateException("Exiting without changing anything. Table folder does not exist: " + tableDir);
            }
            if (!this.fs.getFileStatus(tableDir).isDirectory()) {
                throw new IllegalStateException("Exiting without changing anything. Table folder is not a directory: " + tableDir);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while trying to find table folder for table {}", (Object)tableName, (Object)e);
            throw new IllegalStateException("Exiting without changing anything. Can not validate if table folder exists.");
        }
    }

    private boolean checkIfTableInfoPresent(TableName tableName) {
        Path tableDir = HBCKFsUtils.getTableDir(this.rootDir, tableName);
        try {
            FileStatus tableInfoFile = HBCKFsTableDescriptors.getTableInfoPath(this.fs, tableDir);
            if (tableInfoFile != null) {
                LOG.info("Table descriptor found for table {} in: {}", (Object)tableName, (Object)tableInfoFile.getPath());
                return true;
            }
        }
        catch (IOException e) {
            LOG.error("Exception while trying to find the table descriptor for table {}", (Object)tableName, (Object)e);
            throw new IllegalStateException("Can not validate if table descriptor exists. Exiting without changing anything.");
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private Optional<TableDescriptor> getTableDescriptorFromMaster(TableName tableName) {
        Optional<TableDescriptor> optional;
        Throwable throwable;
        Admin admin;
        Throwable throwable2;
        Connection conn;
        block29: {
            block30: {
                block27: {
                    block28: {
                        LOG.info("Trying to fetch table descriptor for orphan table: {}", (Object)tableName);
                        conn = ConnectionFactory.createConnection((Configuration)this.configuration);
                        throwable2 = null;
                        admin = conn.getAdmin();
                        throwable = null;
                        TableDescriptor tds = admin.getDescriptor(tableName);
                        optional = Optional.of(tds);
                        if (admin == null) break block27;
                        if (throwable == null) break block28;
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    admin.close();
                }
                if (conn == null) break block29;
                if (throwable2 == null) break block30;
                try {
                    conn.close();
                }
                catch (Throwable throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                break block29;
            }
            conn.close();
        }
        return optional;
        {
            catch (Throwable throwable5) {
                try {
                    try {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (admin != null) {
                                    if (throwable != null) {
                                        try {
                                            admin.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        admin.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (conn != null) {
                            if (throwable2 != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                }
                            } else {
                                conn.close();
                            }
                        }
                        throw throwable9;
                    }
                }
                catch (TableNotFoundException e) {
                    LOG.info("Table Descriptor not found in HBase Master: {}", (Object)tableName);
                }
                catch (IOException e) {
                    LOG.warn("Exception while fetching table descriptor. Is master offline?", e);
                }
            }
        }
        return Optional.empty();
    }

    private void generateDefaultTableInfo(HBCKFsTableDescriptors fstd, TableName tableName) throws IOException {
        Set<String> columnFamilies = this.getColumnFamilies(tableName);
        if (columnFamilies.isEmpty()) {
            LOG.warn("No column family found in HDFS for table {}.", (Object)tableName);
        } else {
            LOG.info("Column families to be listed in the new table info: {}", (Object)columnFamilies);
        }
        TableDescriptorBuilder tableBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (String columnFamily : columnFamilies) {
            ColumnFamilyDescriptor family = ColumnFamilyDescriptorBuilder.of((String)columnFamily);
            tableBuilder.setColumnFamily(family);
        }
        fstd.createTableDescriptor(tableBuilder.build(), false);
    }

    private Set<String> getColumnFamilies(TableName tableName) {
        try {
            Path tableDir = HBCKFsUtils.getTableDir(this.rootDir, tableName);
            List<Path> regionDirs = HBCKFsUtils.getRegionDirs(this.fs, tableDir);
            HashSet<String> columnFamilies = new HashSet<String>();
            for (Path regionDir : regionDirs) {
                FileStatus[] familyDirs;
                for (FileStatus familyDir : familyDirs = this.fs.listStatus(regionDir, (PathFilter)new HBCKFsUtils.FamilyDirFilter(this.fs))) {
                    String columnFamily = familyDir.getPath().getName();
                    columnFamilies.add(columnFamily);
                }
            }
            return columnFamilies;
        }
        catch (IOException e) {
            LOG.error("Exception while trying to find in HDFS the column families for table {}", (Object)tableName, (Object)e);
            throw new IllegalStateException("Unable to determine the list of column families. Exiting without changing anything.");
        }
    }
}

