/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite.internal.marshaller.ClientMarshallerWriter;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerException;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientKeyValueView<K, V>
implements KeyValueView<K, V> {
    private final ClientTable tbl;
    private final ClientRecordSerializer<K> keySer;
    private final ClientRecordSerializer<V> valSer;

    public ClientKeyValueView(ClientTable tbl, Mapper<K> keyMapper, Mapper<V> valMapper) {
        assert (tbl != null);
        assert (keyMapper != null);
        assert (valMapper != null);
        this.tbl = tbl;
        this.keySer = new ClientRecordSerializer<K>(tbl.tableId(), keyMapper);
        this.valSer = new ClientRecordSerializer<V>(tbl.tableId(), valMapper);
    }

    public V get(@Nullable Transaction tx, @NotNull K key) {
        return ClientUtils.sync(this.getAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, @NotNull K key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.valSer.readRec((ClientSchema)s, (ClientMessageUnpacker)r, TuplePart.VAL), null, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, @NotNull K key) {
        return ClientUtils.sync(this.getNullableAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, @NotNull K key) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public V getOrDefault(@Nullable Transaction tx, @NotNull K key, V defaultValue) {
        return ClientUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @NotNull
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, @NotNull K key, V defaultValue) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Map<K, V> getAll(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        return ClientUtils.sync(this.getAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), this::readGetAllResponse, Collections.emptyMap(), ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), keys.iterator().next()));
    }

    public boolean contains(@Nullable Transaction tx, @NotNull K key) {
        return ClientUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, @NotNull K key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public void put(@Nullable Transaction tx, @NotNull K key, V val) {
        ClientUtils.sync(this.putAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(10, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), r -> null, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public void putAll(@Nullable Transaction tx, @NotNull Map<K, V> pairs) {
        ClientUtils.sync(this.putAllAsync(tx, pairs));
    }

    @NotNull
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, @NotNull Map<K, V> pairs) {
        Objects.requireNonNull(pairs);
        if (pairs.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.tbl.doSchemaOutOpAsync(13, (s, w) -> {
            this.writeSchemaAndTx((ClientSchema)s, (PayloadOutputChannel)w, tx);
            w.out().packInt(pairs.size());
            for (Map.Entry e : pairs.entrySet()) {
                this.writeKeyValueRaw((ClientSchema)s, (PayloadOutputChannel)w, e.getKey(), e.getValue());
            }
        }, r -> null, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), pairs.keySet().iterator().next()));
    }

    public V getAndPut(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        return ClientUtils.sync(this.getAndPutAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), (s, r) -> this.valSer.readRec((ClientSchema)s, (ClientMessageUnpacker)r, TuplePart.VAL), null, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, @NotNull K key, V val) {
        return ClientUtils.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean putIfAbsent(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        return ClientUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(18, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public boolean remove(@Nullable Transaction tx, @NotNull K key) {
        return ClientUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, @NotNull K key, V val) {
        return ClientUtils.sync(this.removeAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull K key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(28, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(30, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public Collection<K> removeAll(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        return ClientUtils.sync(this.removeAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, @NotNull Collection<K> keys) {
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.keySer.readRecs((ClientSchema)s, (ClientMessageUnpacker)r, false, TuplePart.KEY), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), keys.iterator().next()));
    }

    public V getAndRemove(@Nullable Transaction tx, @NotNull K key) {
        return ClientUtils.sync(this.getAndRemoveAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, @NotNull K key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.valSer.readRec((ClientSchema)s, (ClientMessageUnpacker)r, TuplePart.VAL), null, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, @NotNull K key) {
        return ClientUtils.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, @NotNull K key) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean replace(@Nullable Transaction tx, @NotNull K key, V val) {
        return ClientUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull K key, V oldVal, V newVal) {
        Objects.requireNonNull(key);
        return ClientUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(22, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull K key, V oldVal, V newVal) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(24, (s, w) -> {
            this.writeSchemaAndTx((ClientSchema)s, (PayloadOutputChannel)w, tx);
            this.writeKeyValueRaw((ClientSchema)s, (PayloadOutputChannel)w, key, oldVal);
            this.writeKeyValueRaw((ClientSchema)s, (PayloadOutputChannel)w, key, newVal);
        }, ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public V getAndReplace(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        return ClientUtils.sync(this.getAndReplaceAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, @NotNull K key, @NotNull V val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), (s, r) -> this.valSer.readRec((ClientSchema)s, (ClientMessageUnpacker)r, TuplePart.VAL), null, ClientTupleSerializer.getHashFunction(tx, this.keySer.mapper(), key));
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, @NotNull K key, V val) {
        return ClientUtils.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, @NotNull K key, V val) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <R extends Serializable> R invoke(@Nullable Transaction tx, @NotNull K key, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<R> invokeAsync(@Nullable Transaction tx, @NotNull K key, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <R extends Serializable> Map<K, R> invokeAll(@Nullable Transaction tx, @NotNull Collection<K> keys, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<Map<K, R>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<K> keys, InvokeProcessor<K, V, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private void writeKeyValue(ClientSchema s, PayloadOutputChannel w, @Nullable Transaction tx, @NotNull K key, V val) {
        this.writeSchemaAndTx(s, w, tx);
        this.writeKeyValueRaw(s, w, key, val);
    }

    private void writeKeyValueRaw(ClientSchema s, PayloadOutputChannel w, @NotNull K key, V val) {
        BinaryTupleBuilder builder = new BinaryTupleBuilder(s.columns().length, true);
        BitSet noValueSet = new BitSet();
        ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
        try {
            s.getMarshaller(this.keySer.mapper(), TuplePart.KEY).writeObject(key, (MarshallerWriter)writer);
            s.getMarshaller(this.valSer.mapper(), TuplePart.VAL).writeObject(val, (MarshallerWriter)writer);
        }
        catch (MarshallerException e) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), (Throwable)e);
        }
        w.out().packBinaryTuple(builder, noValueSet);
    }

    private void writeSchemaAndTx(ClientSchema s, PayloadOutputChannel w, @Nullable Transaction tx) {
        w.out().packUuid(this.tbl.tableId());
        ClientTable.writeTx(tx, w);
        w.out().packInt(s.version());
    }

    private HashMap<K, V> readGetAllResponse(ClientSchema schema, ClientMessageUnpacker in) {
        int cnt = in.unpackInt();
        LinkedHashMap<Object, Object> res = new LinkedHashMap<Object, Object>(cnt);
        Marshaller keyMarsh = schema.getMarshaller(this.keySer.mapper(), TuplePart.KEY);
        Marshaller valMarsh = schema.getMarshaller(this.valSer.mapper(), TuplePart.VAL);
        try {
            for (int i = 0; i < cnt; ++i) {
                in.unpackBoolean();
                BinaryTupleReader tupleReader = new BinaryTupleReader(schema.columns().length, in.readBinaryUnsafe());
                ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader);
                res.put(keyMarsh.readObject((MarshallerReader)reader, null), valMarsh.readObject((MarshallerReader)reader, null));
            }
            return res;
        }
        catch (MarshallerException e) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), (Throwable)e);
        }
    }
}

