/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.util.function.Supplier;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.jetbrains.annotations.Nullable;

public class MarshallerColumn {
    private static final Supplier<Object> NULL_SUPPLIER = () -> null;
    private final String name;
    private final BinaryMode type;
    private final int scale;
    @IgniteToStringExclude
    private final Supplier<Object> defValSup;

    public MarshallerColumn(String name, BinaryMode type) {
        this(name, type, null, 0);
    }

    public MarshallerColumn(String name, BinaryMode type, @Nullable Supplier<Object> defValSup, int scale) {
        this.name = name;
        this.type = type;
        this.defValSup = defValSup == null ? NULL_SUPPLIER : defValSup;
        this.scale = scale;
    }

    public String name() {
        return this.name;
    }

    public BinaryMode type() {
        return this.type;
    }

    public Object defaultValue() {
        return this.defValSup.get();
    }

    public int scale() {
        return this.scale;
    }
}

