/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.util.Objects;
import org.apache.ignite.internal.tostring.S;

public abstract class CatalogObjectDescriptor {
    private final int id;
    private final String name;
    private final Type type;
    private long updateToken;

    CatalogObjectDescriptor(int id, Type type, String name, long causalityToken) {
        this.id = id;
        this.type = Objects.requireNonNull(type, "type");
        this.name = Objects.requireNonNull(name, "name");
        this.updateToken = causalityToken;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public long updateToken() {
        return this.updateToken;
    }

    public void updateToken(long updateToken) {
        assert (this.updateToken == 0L) : "Update token for the descriptor must be updated only once";
        this.updateToken = updateToken;
    }

    public String toString() {
        return S.toString(CatalogObjectDescriptor.class, (Object)this);
    }

    public static enum Type {
        SCHEMA,
        TABLE,
        INDEX,
        ZONE,
        SYSTEM_VIEW;

    }
}

