/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RelBuilder", generator="Immutables")
final class ImmutableRelBuilder {
    private ImmutableRelBuilder() {
    }

    @CheckReturnValue
    @Generated(from="RelBuilder.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements RelBuilder.Config {
        private final int bloat;
        private final boolean dedupAggregateCalls;
        private final boolean pruneInputOfAggregate;
        private final boolean preventEmptyFieldList;
        private final boolean pushJoinCondition;
        private final boolean simplify;
        private final boolean simplifyLimit;
        private final boolean simplifyValues;
        private final boolean aggregateUnique;
        private final boolean convertCorrelateToJoin;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.bloat = this.initShim.bloat();
            this.dedupAggregateCalls = this.initShim.dedupAggregateCalls();
            this.pruneInputOfAggregate = this.initShim.pruneInputOfAggregate();
            this.preventEmptyFieldList = this.initShim.preventEmptyFieldList();
            this.pushJoinCondition = this.initShim.pushJoinCondition();
            this.simplify = this.initShim.simplify();
            this.simplifyLimit = this.initShim.simplifyLimit();
            this.simplifyValues = this.initShim.simplifyValues();
            this.aggregateUnique = this.initShim.aggregateUnique();
            this.convertCorrelateToJoin = this.initShim.convertCorrelateToJoin();
            this.initShim = null;
        }

        private Config(Builder builder) {
            if (builder.bloatIsSet()) {
                this.initShim.withBloat(builder.bloat);
            }
            if (builder.dedupAggregateCallsIsSet()) {
                this.initShim.withDedupAggregateCalls(builder.dedupAggregateCalls);
            }
            if (builder.pruneInputOfAggregateIsSet()) {
                this.initShim.withPruneInputOfAggregate(builder.pruneInputOfAggregate);
            }
            if (builder.preventEmptyFieldListIsSet()) {
                this.initShim.withPreventEmptyFieldList(builder.preventEmptyFieldList);
            }
            if (builder.pushJoinConditionIsSet()) {
                this.initShim.withPushJoinCondition(builder.pushJoinCondition);
            }
            if (builder.simplifyIsSet()) {
                this.initShim.withSimplify(builder.simplify);
            }
            if (builder.simplifyLimitIsSet()) {
                this.initShim.withSimplifyLimit(builder.simplifyLimit);
            }
            if (builder.simplifyValuesIsSet()) {
                this.initShim.withSimplifyValues(builder.simplifyValues);
            }
            if (builder.aggregateUniqueIsSet()) {
                this.initShim.withAggregateUnique(builder.aggregateUnique);
            }
            if (builder.convertCorrelateToJoinIsSet()) {
                this.initShim.withConvertCorrelateToJoin(builder.convertCorrelateToJoin);
            }
            this.bloat = this.initShim.bloat();
            this.dedupAggregateCalls = this.initShim.dedupAggregateCalls();
            this.pruneInputOfAggregate = this.initShim.pruneInputOfAggregate();
            this.preventEmptyFieldList = this.initShim.preventEmptyFieldList();
            this.pushJoinCondition = this.initShim.pushJoinCondition();
            this.simplify = this.initShim.simplify();
            this.simplifyLimit = this.initShim.simplifyLimit();
            this.simplifyValues = this.initShim.simplifyValues();
            this.aggregateUnique = this.initShim.aggregateUnique();
            this.convertCorrelateToJoin = this.initShim.convertCorrelateToJoin();
            this.initShim = null;
        }

        private Config(int bloat, boolean dedupAggregateCalls, boolean pruneInputOfAggregate, boolean preventEmptyFieldList, boolean pushJoinCondition, boolean simplify, boolean simplifyLimit, boolean simplifyValues, boolean aggregateUnique, boolean convertCorrelateToJoin) {
            this.bloat = bloat;
            this.dedupAggregateCalls = dedupAggregateCalls;
            this.pruneInputOfAggregate = pruneInputOfAggregate;
            this.preventEmptyFieldList = preventEmptyFieldList;
            this.pushJoinCondition = pushJoinCondition;
            this.simplify = simplify;
            this.simplifyLimit = simplifyLimit;
            this.simplifyValues = simplifyValues;
            this.aggregateUnique = aggregateUnique;
            this.convertCorrelateToJoin = convertCorrelateToJoin;
            this.initShim = null;
        }

        private int bloatInitialize() {
            return RelBuilder.Config.super.bloat();
        }

        private boolean dedupAggregateCallsInitialize() {
            return RelBuilder.Config.super.dedupAggregateCalls();
        }

        private boolean pruneInputOfAggregateInitialize() {
            return RelBuilder.Config.super.pruneInputOfAggregate();
        }

        private boolean preventEmptyFieldListInitialize() {
            return RelBuilder.Config.super.preventEmptyFieldList();
        }

        private boolean pushJoinConditionInitialize() {
            return RelBuilder.Config.super.pushJoinCondition();
        }

        private boolean simplifyInitialize() {
            return RelBuilder.Config.super.simplify();
        }

        private boolean simplifyLimitInitialize() {
            return RelBuilder.Config.super.simplifyLimit();
        }

        private boolean simplifyValuesInitialize() {
            return RelBuilder.Config.super.simplifyValues();
        }

        private boolean aggregateUniqueInitialize() {
            return RelBuilder.Config.super.aggregateUnique();
        }

        private boolean convertCorrelateToJoinInitialize() {
            return RelBuilder.Config.super.convertCorrelateToJoin();
        }

        @Override
        public int bloat() {
            InitShim shim = this.initShim;
            return shim != null ? shim.bloat() : this.bloat;
        }

        @Override
        public boolean dedupAggregateCalls() {
            InitShim shim = this.initShim;
            return shim != null ? shim.dedupAggregateCalls() : this.dedupAggregateCalls;
        }

        @Override
        public boolean pruneInputOfAggregate() {
            InitShim shim = this.initShim;
            return shim != null ? shim.pruneInputOfAggregate() : this.pruneInputOfAggregate;
        }

        @Override
        public boolean preventEmptyFieldList() {
            InitShim shim = this.initShim;
            return shim != null ? shim.preventEmptyFieldList() : this.preventEmptyFieldList;
        }

        @Override
        public boolean pushJoinCondition() {
            InitShim shim = this.initShim;
            return shim != null ? shim.pushJoinCondition() : this.pushJoinCondition;
        }

        @Override
        public boolean simplify() {
            InitShim shim = this.initShim;
            return shim != null ? shim.simplify() : this.simplify;
        }

        @Override
        public boolean simplifyLimit() {
            InitShim shim = this.initShim;
            return shim != null ? shim.simplifyLimit() : this.simplifyLimit;
        }

        @Override
        public boolean simplifyValues() {
            InitShim shim = this.initShim;
            return shim != null ? shim.simplifyValues() : this.simplifyValues;
        }

        @Override
        public boolean aggregateUnique() {
            InitShim shim = this.initShim;
            return shim != null ? shim.aggregateUnique() : this.aggregateUnique;
        }

        @Override
        public boolean convertCorrelateToJoin() {
            InitShim shim = this.initShim;
            return shim != null ? shim.convertCorrelateToJoin() : this.convertCorrelateToJoin;
        }

        @Override
        public final Config withBloat(int value) {
            if (this.bloat == value) {
                return this;
            }
            return Config.validate(new Config(value, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withDedupAggregateCalls(boolean value) {
            if (this.dedupAggregateCalls == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, value, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withPruneInputOfAggregate(boolean value) {
            if (this.pruneInputOfAggregate == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, value, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withPreventEmptyFieldList(boolean value) {
            if (this.preventEmptyFieldList == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, value, this.pushJoinCondition, this.simplify, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withPushJoinCondition(boolean value) {
            if (this.pushJoinCondition == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, value, this.simplify, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withSimplify(boolean value) {
            if (this.simplify == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, value, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withSimplifyLimit(boolean value) {
            if (this.simplifyLimit == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, value, this.simplifyValues, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withSimplifyValues(boolean value) {
            if (this.simplifyValues == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, this.simplifyLimit, value, this.aggregateUnique, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withAggregateUnique(boolean value) {
            if (this.aggregateUnique == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, this.simplifyLimit, this.simplifyValues, value, this.convertCorrelateToJoin));
        }

        @Override
        public final Config withConvertCorrelateToJoin(boolean value) {
            if (this.convertCorrelateToJoin == value) {
                return this;
            }
            return Config.validate(new Config(this.bloat, this.dedupAggregateCalls, this.pruneInputOfAggregate, this.preventEmptyFieldList, this.pushJoinCondition, this.simplify, this.simplifyLimit, this.simplifyValues, this.aggregateUnique, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.bloat == another.bloat && this.dedupAggregateCalls == another.dedupAggregateCalls && this.pruneInputOfAggregate == another.pruneInputOfAggregate && this.preventEmptyFieldList == another.preventEmptyFieldList && this.pushJoinCondition == another.pushJoinCondition && this.simplify == another.simplify && this.simplifyLimit == another.simplifyLimit && this.simplifyValues == another.simplifyValues && this.aggregateUnique == another.aggregateUnique && this.convertCorrelateToJoin == another.convertCorrelateToJoin;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.bloat;
            h += (h << 5) + Booleans.hashCode((boolean)this.dedupAggregateCalls);
            h += (h << 5) + Booleans.hashCode((boolean)this.pruneInputOfAggregate);
            h += (h << 5) + Booleans.hashCode((boolean)this.preventEmptyFieldList);
            h += (h << 5) + Booleans.hashCode((boolean)this.pushJoinCondition);
            h += (h << 5) + Booleans.hashCode((boolean)this.simplify);
            h += (h << 5) + Booleans.hashCode((boolean)this.simplifyLimit);
            h += (h << 5) + Booleans.hashCode((boolean)this.simplifyValues);
            h += (h << 5) + Booleans.hashCode((boolean)this.aggregateUnique);
            h += (h << 5) + Booleans.hashCode((boolean)this.convertCorrelateToJoin);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("bloat", this.bloat).add("dedupAggregateCalls", this.dedupAggregateCalls).add("pruneInputOfAggregate", this.pruneInputOfAggregate).add("preventEmptyFieldList", this.preventEmptyFieldList).add("pushJoinCondition", this.pushJoinCondition).add("simplify", this.simplify).add("simplifyLimit", this.simplifyLimit).add("simplifyValues", this.simplifyValues).add("aggregateUnique", this.aggregateUnique).add("convertCorrelateToJoin", this.convertCorrelateToJoin).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(RelBuilder.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="RelBuilder.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_BLOAT = 1L;
            private static final long OPT_BIT_DEDUP_AGGREGATE_CALLS = 2L;
            private static final long OPT_BIT_PRUNE_INPUT_OF_AGGREGATE = 4L;
            private static final long OPT_BIT_PREVENT_EMPTY_FIELD_LIST = 8L;
            private static final long OPT_BIT_PUSH_JOIN_CONDITION = 16L;
            private static final long OPT_BIT_SIMPLIFY = 32L;
            private static final long OPT_BIT_SIMPLIFY_LIMIT = 64L;
            private static final long OPT_BIT_SIMPLIFY_VALUES = 128L;
            private static final long OPT_BIT_AGGREGATE_UNIQUE = 256L;
            private static final long OPT_BIT_CONVERT_CORRELATE_TO_JOIN = 512L;
            private long optBits;
            private int bloat;
            private boolean dedupAggregateCalls;
            private boolean pruneInputOfAggregate;
            private boolean preventEmptyFieldList;
            private boolean pushJoinCondition;
            private boolean simplify;
            private boolean simplifyLimit;
            private boolean simplifyValues;
            private boolean aggregateUnique;
            private boolean convertCorrelateToJoin;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelBuilder.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.withBloat(instance.bloat());
                this.withDedupAggregateCalls(instance.dedupAggregateCalls());
                this.withPruneInputOfAggregate(instance.pruneInputOfAggregate());
                this.withPreventEmptyFieldList(instance.preventEmptyFieldList());
                this.withPushJoinCondition(instance.pushJoinCondition());
                this.withSimplify(instance.simplify());
                this.withSimplifyLimit(instance.simplifyLimit());
                this.withSimplifyValues(instance.simplifyValues());
                this.withAggregateUnique(instance.aggregateUnique());
                this.withConvertCorrelateToJoin(instance.convertCorrelateToJoin());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withBloat(int bloat) {
                this.bloat = bloat;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDedupAggregateCalls(boolean dedupAggregateCalls) {
                this.dedupAggregateCalls = dedupAggregateCalls;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withPruneInputOfAggregate(boolean pruneInputOfAggregate) {
                this.pruneInputOfAggregate = pruneInputOfAggregate;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withPreventEmptyFieldList(boolean preventEmptyFieldList) {
                this.preventEmptyFieldList = preventEmptyFieldList;
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withPushJoinCondition(boolean pushJoinCondition) {
                this.pushJoinCondition = pushJoinCondition;
                this.optBits |= 0x10L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withSimplify(boolean simplify) {
                this.simplify = simplify;
                this.optBits |= 0x20L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withSimplifyLimit(boolean simplifyLimit) {
                this.simplifyLimit = simplifyLimit;
                this.optBits |= 0x40L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withSimplifyValues(boolean simplifyValues) {
                this.simplifyValues = simplifyValues;
                this.optBits |= 0x80L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withAggregateUnique(boolean aggregateUnique) {
                this.aggregateUnique = aggregateUnique;
                this.optBits |= 0x100L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withConvertCorrelateToJoin(boolean convertCorrelateToJoin) {
                this.convertCorrelateToJoin = convertCorrelateToJoin;
                this.optBits |= 0x200L;
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean bloatIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean dedupAggregateCallsIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean pruneInputOfAggregateIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean preventEmptyFieldListIsSet() {
                return (this.optBits & 8L) != 0L;
            }

            private boolean pushJoinConditionIsSet() {
                return (this.optBits & 0x10L) != 0L;
            }

            private boolean simplifyIsSet() {
                return (this.optBits & 0x20L) != 0L;
            }

            private boolean simplifyLimitIsSet() {
                return (this.optBits & 0x40L) != 0L;
            }

            private boolean simplifyValuesIsSet() {
                return (this.optBits & 0x80L) != 0L;
            }

            private boolean aggregateUniqueIsSet() {
                return (this.optBits & 0x100L) != 0L;
            }

            private boolean convertCorrelateToJoinIsSet() {
                return (this.optBits & 0x200L) != 0L;
            }
        }

        @Generated(from="RelBuilder.Config", generator="Immutables")
        private final class InitShim {
            private byte bloatBuildStage = 0;
            private int bloat;
            private byte dedupAggregateCallsBuildStage = 0;
            private boolean dedupAggregateCalls;
            private byte pruneInputOfAggregateBuildStage = 0;
            private boolean pruneInputOfAggregate;
            private byte preventEmptyFieldListBuildStage = 0;
            private boolean preventEmptyFieldList;
            private byte pushJoinConditionBuildStage = 0;
            private boolean pushJoinCondition;
            private byte simplifyBuildStage = 0;
            private boolean simplify;
            private byte simplifyLimitBuildStage = 0;
            private boolean simplifyLimit;
            private byte simplifyValuesBuildStage = 0;
            private boolean simplifyValues;
            private byte aggregateUniqueBuildStage = 0;
            private boolean aggregateUnique;
            private byte convertCorrelateToJoinBuildStage = 0;
            private boolean convertCorrelateToJoin;

            private InitShim() {
            }

            int bloat() {
                if (this.bloatBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.bloatBuildStage == 0) {
                    this.bloatBuildStage = (byte)-1;
                    this.bloat = Config.this.bloatInitialize();
                    this.bloatBuildStage = 1;
                }
                return this.bloat;
            }

            void withBloat(int bloat) {
                this.bloat = bloat;
                this.bloatBuildStage = 1;
            }

            boolean dedupAggregateCalls() {
                if (this.dedupAggregateCallsBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.dedupAggregateCallsBuildStage == 0) {
                    this.dedupAggregateCallsBuildStage = (byte)-1;
                    this.dedupAggregateCalls = Config.this.dedupAggregateCallsInitialize();
                    this.dedupAggregateCallsBuildStage = 1;
                }
                return this.dedupAggregateCalls;
            }

            void withDedupAggregateCalls(boolean dedupAggregateCalls) {
                this.dedupAggregateCalls = dedupAggregateCalls;
                this.dedupAggregateCallsBuildStage = 1;
            }

            boolean pruneInputOfAggregate() {
                if (this.pruneInputOfAggregateBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.pruneInputOfAggregateBuildStage == 0) {
                    this.pruneInputOfAggregateBuildStage = (byte)-1;
                    this.pruneInputOfAggregate = Config.this.pruneInputOfAggregateInitialize();
                    this.pruneInputOfAggregateBuildStage = 1;
                }
                return this.pruneInputOfAggregate;
            }

            void withPruneInputOfAggregate(boolean pruneInputOfAggregate) {
                this.pruneInputOfAggregate = pruneInputOfAggregate;
                this.pruneInputOfAggregateBuildStage = 1;
            }

            boolean preventEmptyFieldList() {
                if (this.preventEmptyFieldListBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.preventEmptyFieldListBuildStage == 0) {
                    this.preventEmptyFieldListBuildStage = (byte)-1;
                    this.preventEmptyFieldList = Config.this.preventEmptyFieldListInitialize();
                    this.preventEmptyFieldListBuildStage = 1;
                }
                return this.preventEmptyFieldList;
            }

            void withPreventEmptyFieldList(boolean preventEmptyFieldList) {
                this.preventEmptyFieldList = preventEmptyFieldList;
                this.preventEmptyFieldListBuildStage = 1;
            }

            boolean pushJoinCondition() {
                if (this.pushJoinConditionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.pushJoinConditionBuildStage == 0) {
                    this.pushJoinConditionBuildStage = (byte)-1;
                    this.pushJoinCondition = Config.this.pushJoinConditionInitialize();
                    this.pushJoinConditionBuildStage = 1;
                }
                return this.pushJoinCondition;
            }

            void withPushJoinCondition(boolean pushJoinCondition) {
                this.pushJoinCondition = pushJoinCondition;
                this.pushJoinConditionBuildStage = 1;
            }

            boolean simplify() {
                if (this.simplifyBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.simplifyBuildStage == 0) {
                    this.simplifyBuildStage = (byte)-1;
                    this.simplify = Config.this.simplifyInitialize();
                    this.simplifyBuildStage = 1;
                }
                return this.simplify;
            }

            void withSimplify(boolean simplify) {
                this.simplify = simplify;
                this.simplifyBuildStage = 1;
            }

            boolean simplifyLimit() {
                if (this.simplifyLimitBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.simplifyLimitBuildStage == 0) {
                    this.simplifyLimitBuildStage = (byte)-1;
                    this.simplifyLimit = Config.this.simplifyLimitInitialize();
                    this.simplifyLimitBuildStage = 1;
                }
                return this.simplifyLimit;
            }

            void withSimplifyLimit(boolean simplifyLimit) {
                this.simplifyLimit = simplifyLimit;
                this.simplifyLimitBuildStage = 1;
            }

            boolean simplifyValues() {
                if (this.simplifyValuesBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.simplifyValuesBuildStage == 0) {
                    this.simplifyValuesBuildStage = (byte)-1;
                    this.simplifyValues = Config.this.simplifyValuesInitialize();
                    this.simplifyValuesBuildStage = 1;
                }
                return this.simplifyValues;
            }

            void withSimplifyValues(boolean simplifyValues) {
                this.simplifyValues = simplifyValues;
                this.simplifyValuesBuildStage = 1;
            }

            boolean aggregateUnique() {
                if (this.aggregateUniqueBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.aggregateUniqueBuildStage == 0) {
                    this.aggregateUniqueBuildStage = (byte)-1;
                    this.aggregateUnique = Config.this.aggregateUniqueInitialize();
                    this.aggregateUniqueBuildStage = 1;
                }
                return this.aggregateUnique;
            }

            void withAggregateUnique(boolean aggregateUnique) {
                this.aggregateUnique = aggregateUnique;
                this.aggregateUniqueBuildStage = 1;
            }

            boolean convertCorrelateToJoin() {
                if (this.convertCorrelateToJoinBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.convertCorrelateToJoinBuildStage == 0) {
                    this.convertCorrelateToJoinBuildStage = (byte)-1;
                    this.convertCorrelateToJoin = Config.this.convertCorrelateToJoinInitialize();
                    this.convertCorrelateToJoinBuildStage = 1;
                }
                return this.convertCorrelateToJoin;
            }

            void withConvertCorrelateToJoin(boolean convertCorrelateToJoin) {
                this.convertCorrelateToJoin = convertCorrelateToJoin;
                this.convertCorrelateToJoinBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.bloatBuildStage == -1) {
                    attributes.add("bloat");
                }
                if (this.dedupAggregateCallsBuildStage == -1) {
                    attributes.add("dedupAggregateCalls");
                }
                if (this.pruneInputOfAggregateBuildStage == -1) {
                    attributes.add("pruneInputOfAggregate");
                }
                if (this.preventEmptyFieldListBuildStage == -1) {
                    attributes.add("preventEmptyFieldList");
                }
                if (this.pushJoinConditionBuildStage == -1) {
                    attributes.add("pushJoinCondition");
                }
                if (this.simplifyBuildStage == -1) {
                    attributes.add("simplify");
                }
                if (this.simplifyLimitBuildStage == -1) {
                    attributes.add("simplifyLimit");
                }
                if (this.simplifyValuesBuildStage == -1) {
                    attributes.add("simplifyValues");
                }
                if (this.aggregateUniqueBuildStage == -1) {
                    attributes.add("aggregateUnique");
                }
                if (this.convertCorrelateToJoinBuildStage == -1) {
                    attributes.add("convertCorrelateToJoin");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

