/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.pmtiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

enum Compression {
    Unknown,
    None,
    Gzip,
    Brotli,
    Zstd;


    InputStream decompress(InputStream inputStream) throws IOException {
        return switch (this) {
            case None -> inputStream;
            case Gzip -> Compression.decompressGzip(inputStream);
            case Brotli -> Compression.decompressBrotli(inputStream);
            case Zstd -> Compression.decompressZstd(inputStream);
            default -> throw new RuntimeException("Unknown compression");
        };
    }

    static InputStream decompressGzip(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream);
    }

    static InputStream decompressBrotli(InputStream buffer) {
        throw new RuntimeException("Brotli compression not implemented");
    }

    static InputStream decompressZstd(InputStream buffer) {
        throw new RuntimeException("Zstd compression not implemented");
    }

    OutputStream compress(OutputStream outputStream) throws IOException {
        return switch (this) {
            case None -> outputStream;
            case Gzip -> Compression.compressGzip(outputStream);
            case Brotli -> Compression.compressBrotli(outputStream);
            case Zstd -> Compression.compressZstd(outputStream);
            default -> throw new RuntimeException("Unknown compression");
        };
    }

    static OutputStream compressGzip(OutputStream outputStream) throws IOException {
        return new GZIPOutputStream(outputStream);
    }

    static OutputStream compressBrotli(OutputStream outputStream) {
        throw new RuntimeException("Brotli compression not implemented");
    }

    static OutputStream compressZstd(OutputStream outputStream) {
        throw new RuntimeException("Zstd compression not implemented");
    }
}

