/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ConnectionPoolMetrics {
    private static final String PROTOCOL = "protocol";
    private static final String REMOTE_IP = "remote.ip";
    private static final String LOCAL_IP = "local.ip";
    private static final String STATE = "state";
    private final MeterRegistry meterRegistry;
    private final MeterIdPrefix idPrefix;
    @GuardedBy(value="lock")
    private final Map<List<Tag>, Meters> metersMap = new HashMap<List<Tag>, Meters>();
    private final ReentrantShortLock lock = new ReentrantShortLock();

    ConnectionPoolMetrics(MeterRegistry meterRegistry, MeterIdPrefix idPrefix) {
        this.idPrefix = idPrefix;
        this.meterRegistry = meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseConnOpened(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        List<Tag> commonTags = this.commonTags(protocol, remoteAddr, localAddr);
        this.lock.lock();
        try {
            Meters meters = this.metersMap.computeIfAbsent(commonTags, key -> new Meters(this.idPrefix, (List<Tag>)key, this.meterRegistry));
            meters.increment();
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<Tag> commonTags(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        return this.idPrefix.tags(PROTOCOL, protocol.name(), REMOTE_IP, remoteAddr.getAddress().getHostAddress(), LOCAL_IP, localAddr.getAddress().getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseConnClosed(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        List<Tag> commonTags = this.commonTags(protocol, remoteAddr, localAddr);
        this.lock.lock();
        try {
            Meters meters = this.metersMap.get(commonTags);
            if (meters != null) {
                meters.decrement();
                assert (meters.activeConnections() >= 0) : "active connections should not be negative. " + meters;
                if (meters.activeConnections() == 0) {
                    this.metersMap.remove(commonTags);
                    meters.remove(this.meterRegistry);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class Meters {
        private final Counter opened;
        private final Counter closed;
        private final Gauge active;
        private int activeConnections;

        Meters(MeterIdPrefix idPrefix, List<Tag> commonTags, MeterRegistry registry) {
            this.opened = Counter.builder((String)idPrefix.name("connections")).tags(commonTags).tag(ConnectionPoolMetrics.STATE, "opened").register(registry);
            this.closed = Counter.builder((String)idPrefix.name("connections")).tags(commonTags).tag(ConnectionPoolMetrics.STATE, "closed").register(registry);
            this.active = Gauge.builder((String)idPrefix.name("active.connections"), (Object)this, Meters::activeConnections).tags(commonTags).register(registry);
        }

        Meters increment() {
            ++this.activeConnections;
            this.opened.increment();
            return this;
        }

        Meters decrement() {
            --this.activeConnections;
            this.closed.increment();
            return this;
        }

        int activeConnections() {
            return this.activeConnections;
        }

        void remove(MeterRegistry registry) {
            registry.remove((Meter)this.opened);
            registry.remove((Meter)this.closed);
            registry.remove((Meter)this.active);
        }
    }
}

