/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.domain;

import java.io.Serializable;
import java.util.ArrayList;
import org.ansj.domain.Nature;
import org.ansj.domain.NumNatureAttr;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.TermNature;

public class TermNatures
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TermNatures M = new TermNatures(TermNature.M);
    public static final TermNatures M_ALB = new TermNatures(TermNature.M);
    public static final TermNatures NR = new TermNatures(TermNature.NR);
    public static final TermNatures EN = new TermNatures(TermNature.EN);
    public static final TermNatures END = new TermNatures(TermNature.END, 50610, -1);
    public static final TermNatures BEGIN = new TermNatures(TermNature.BEGIN, 50610, 0);
    public static final TermNatures NT = new TermNatures(TermNature.NT);
    public static final TermNatures NS = new TermNatures(TermNature.NS);
    public static final TermNatures NRF = new TermNatures(TermNature.NRF);
    public static final TermNatures NW = new TermNatures(TermNature.NW);
    public static final TermNatures NULL = new TermNatures(TermNature.NULL);
    public TermNature[] termNatures = null;
    public NumNatureAttr numAttr = NumNatureAttr.NULL;
    public PersonNatureAttr personAttr = PersonNatureAttr.NULL;
    public Nature nature = null;
    public int allFreq = 0;
    public int id = -2;

    public TermNatures(String natureStr, int id) {
        this.id = id;
        this.termNatures = this.termNatures;
        natureStr = natureStr.substring(1, natureStr.length() - 1);
        String[] split = natureStr.split(",");
        ArrayList<TermNature> all = new ArrayList<TermNature>();
        TermNature maxTermNature = null;
        int maxFreq = 0;
        int frequency = -1;
        int size = 0;
        for (int i = 0; i < split.length; ++i) {
            String[] strs = split[i].split("=");
            frequency = Integer.parseInt(strs[1]);
            this.allFreq += frequency;
            if (strs[0].startsWith("q_")) {
                this.numAttr = new NumNatureAttr(false, true, strs[0].replaceFirst("q_", ""));
                continue;
            }
            TermNature termNature = new TermNature(strs[0], frequency);
            all.add(termNature);
            if (maxFreq <= frequency) {
                maxFreq = frequency;
                maxTermNature = termNature;
            }
            ++size;
        }
        this.termNatures = all.toArray(new TermNature[all.size()]);
        if (maxTermNature != null) {
            this.nature = maxTermNature.nature;
        } else if (this.numAttr != NumNatureAttr.NULL) {
            this.nature = this.numAttr.nature;
        }
    }

    public TermNatures(TermNature termNature) {
        this.termNatures = new TermNature[1];
        this.termNatures[0] = termNature;
        this.nature = termNature.nature;
    }

    public TermNatures(TermNature termNature, int allFreq, int id) {
        this.id = id;
        this.termNatures = new TermNature[1];
        termNature.frequency = allFreq;
        this.termNatures[0] = termNature;
        this.nature = termNature.nature;
        this.allFreq = allFreq;
    }

    public void setPersonNatureAttr(PersonNatureAttr personAttr) {
        this.personAttr = personAttr;
    }
}

